/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.simba.spring.redis;

import com.google.common.base.Strings;

public class AcquireResult {
    public static final AcquireResult NONE = new AcquireResult("", 0L);
    private final String ownerId;
    private final long transitionAt;

    public AcquireResult(String ownerId, long transitionAt) {
        this.ownerId = ownerId;
        this.transitionAt = transitionAt;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public long getTransitionAt() {
        return this.transitionAt;
    }

    public static AcquireResult of(String resultStr) {
        if ("@@".equals(resultStr)) {
            return NONE;
        }
        String[] msgs = resultStr.split("@@");
        if (msgs.length != 2) {
            throw new IllegalStateException(Strings.lenientFormat((String)"Incorrect resultStr format:[%s]", (Object[])new Object[]{resultStr}));
        }
        String ownerId = msgs[0];
        long keyTtl = Long.parseLong(msgs[1]);
        long transitionAt = System.currentTimeMillis() + keyTtl;
        return new AcquireResult(ownerId, transitionAt);
    }
}

