/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.govern.discovery.loadbalancer;

import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.ThreadLocalRandom;
import me.ahoo.govern.discovery.ServiceInstance;
import me.ahoo.govern.discovery.loadbalancer.AbstractLoadBalancer;
import me.ahoo.govern.discovery.loadbalancer.LoadBalancer;
import me.ahoo.govern.discovery.redis.ConsistencyRedisServiceDiscovery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeWeightRandomLoadBalancer
extends AbstractLoadBalancer<TreeChooser> {
    private static final Logger log = LoggerFactory.getLogger(TreeWeightRandomLoadBalancer.class);

    public TreeWeightRandomLoadBalancer(ConsistencyRedisServiceDiscovery serviceDiscovery) {
        super(serviceDiscovery);
    }

    @Override
    protected TreeChooser createChooser(List<ServiceInstance> serviceInstances) {
        return new TreeChooser(serviceInstances);
    }

    public static class TreeChooser
    implements LoadBalancer.Chooser {
        private TreeMap<Integer, ServiceInstance> instanceTree;
        private int totalWeight;

        public TreeChooser(List<ServiceInstance> instanceList) {
            this.initTree(instanceList);
        }

        private void initTree(List<ServiceInstance> instanceList) {
            this.instanceTree = new TreeMap();
            int accWeight = 0;
            for (ServiceInstance instance : instanceList) {
                if (instance.getWeight() == 0) continue;
                this.instanceTree.put(accWeight += instance.getWeight(), instance);
            }
            this.totalWeight = accWeight;
        }

        @Override
        public ServiceInstance choose() {
            if (this.instanceTree.size() == 0) {
                if (log.isWarnEnabled()) {
                    log.warn("choose - The size of connector instances is [{}]!", (Object)this.instanceTree.size());
                }
                return null;
            }
            if (0 == this.totalWeight) {
                log.warn("choose - The size of connector instances is [{}],but total weight is 0!", (Object)this.instanceTree.size());
                return null;
            }
            if (this.instanceTree.size() == 1) {
                return this.instanceTree.firstEntry().getValue();
            }
            int randomVal = ThreadLocalRandom.current().nextInt(0, this.totalWeight);
            NavigableMap<Integer, ServiceInstance> tailMap = this.instanceTree.tailMap(randomVal, false);
            return tailMap.firstEntry().getValue();
        }
    }
}

