/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.govern.discovery.loadbalancer;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import me.ahoo.govern.discovery.ServiceInstance;
import me.ahoo.govern.discovery.loadbalancer.AbstractLoadBalancer;
import me.ahoo.govern.discovery.loadbalancer.LoadBalancer;
import me.ahoo.govern.discovery.redis.ConsistencyRedisServiceDiscovery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryWeightRandomLoadBalancer
extends AbstractLoadBalancer<BinaryChooser> {
    private static final Logger log = LoggerFactory.getLogger(BinaryWeightRandomLoadBalancer.class);

    public BinaryWeightRandomLoadBalancer(ConsistencyRedisServiceDiscovery serviceDiscovery) {
        super(serviceDiscovery);
    }

    @Override
    protected BinaryChooser createChooser(List<ServiceInstance> serviceInstances) {
        return new BinaryChooser(serviceInstances);
    }

    public static class BinaryChooser
    implements LoadBalancer.Chooser {
        private final List<ServiceInstance> instanceList;
        private int totalWeight;
        private int randomBound;
        private int[] weightLine;
        private final int maxLineIndex;

        public BinaryChooser(List<ServiceInstance> instanceList) {
            this.maxLineIndex = instanceList.size() - 1;
            this.instanceList = instanceList;
            this.initLine(instanceList);
        }

        private void initLine(List<ServiceInstance> instanceList) {
            this.weightLine = new int[instanceList.size()];
            int accWeight = 0;
            for (int i = 0; i < instanceList.size(); ++i) {
                int instanceWeight = instanceList.get(i).getWeight();
                if (instanceWeight == 0) continue;
                this.weightLine[i] = accWeight += instanceWeight;
            }
            this.totalWeight = accWeight;
            this.randomBound = this.totalWeight + 1;
        }

        @Override
        public ServiceInstance choose() {
            if (this.weightLine.length == 0) {
                if (log.isWarnEnabled()) {
                    log.warn("choose - The size of connector instances is [{}]!", (Object)this.weightLine.length);
                }
                return null;
            }
            if (0 == this.totalWeight) {
                log.warn("choose - The size of connector instances is [{}],but total weight is 0!", (Object)this.weightLine.length);
                return null;
            }
            if (this.weightLine.length == 1) {
                return this.instanceList.get(0);
            }
            int randomValue = ThreadLocalRandom.current().nextInt(1, this.randomBound);
            if (randomValue == 1) {
                return this.instanceList.get(0);
            }
            if (randomValue == this.totalWeight) {
                return this.instanceList.get(this.maxLineIndex);
            }
            int instanceIdx = this.binarySearchLowIndex(randomValue);
            return this.instanceList.get(instanceIdx);
        }

        private int binarySearchLowIndex(int randomValue) {
            int idx = Arrays.binarySearch(this.weightLine, randomValue);
            if (idx < 0) {
                idx = -idx - 1;
            }
            return idx;
        }
    }
}

