/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.govern.discovery.loadbalancer;

import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import me.ahoo.govern.discovery.ServiceInstance;
import me.ahoo.govern.discovery.loadbalancer.AbstractLoadBalancer;
import me.ahoo.govern.discovery.loadbalancer.LoadBalancer;
import me.ahoo.govern.discovery.redis.ConsistencyRedisServiceDiscovery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArrayWeightRandomLoadBalancer
extends AbstractLoadBalancer<ArrayChooser> {
    private static final Logger log = LoggerFactory.getLogger(ArrayWeightRandomLoadBalancer.class);

    public ArrayWeightRandomLoadBalancer(ConsistencyRedisServiceDiscovery serviceDiscovery) {
        super(serviceDiscovery);
    }

    @Override
    protected ArrayChooser createChooser(List<ServiceInstance> serviceInstances) {
        return new ArrayChooser(serviceInstances);
    }

    public static class ArrayChooser
    implements LoadBalancer.Chooser {
        private final ServiceInstance[] instanceLine;
        private final int totalWeight;

        public ArrayChooser(List<ServiceInstance> instanceList) {
            this.totalWeight = instanceList.isEmpty() ? 0 : instanceList.stream().map(node -> node.getWeight()).reduce(Integer::sum).get();
            this.instanceLine = this.toLine(instanceList);
        }

        private ServiceInstance[] toLine(List<ServiceInstance> instanceList) {
            ServiceInstance[] line = new ServiceInstance[this.totalWeight];
            int startX = 0;
            for (ServiceInstance connectorInstance : instanceList) {
                int weightLength = connectorInstance.getWeight();
                int idx = 0;
                while (idx < weightLength) {
                    line[startX] = connectorInstance;
                    ++idx;
                    ++startX;
                }
            }
            return line;
        }

        @Override
        public ServiceInstance choose() {
            if (this.instanceLine.length == 0) {
                if (log.isWarnEnabled()) {
                    log.warn("choose - The size of connector instances is [{}]!", (Object)this.instanceLine.length);
                }
                return null;
            }
            if (0 == this.totalWeight) {
                log.warn("choose - The size of connector instances is [{}],but total weight is 0!", (Object)this.instanceLine.length);
                return null;
            }
            if (this.instanceLine.length == 1) {
                return this.instanceLine[0];
            }
            int randomValue = ThreadLocalRandom.current().nextInt(0, this.totalWeight);
            ServiceInstance instance = this.instanceLine[randomValue];
            return instance;
        }
    }
}

