/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.govern.discovery;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import me.ahoo.govern.discovery.NamespacedServiceInstance;
import me.ahoo.govern.discovery.RenewProperties;
import me.ahoo.govern.discovery.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenewInstanceService {
    private static final Logger log = LoggerFactory.getLogger(RenewInstanceService.class);
    private volatile boolean running;
    private final RenewProperties renewProperties;
    private final ServiceRegistry serviceRegistry;
    private final ScheduledExecutorService scheduledExecutorService;

    public RenewInstanceService(RenewProperties renewProperties, ServiceRegistry serviceRegistry) {
        this(renewProperties, serviceRegistry, new ScheduledThreadPoolExecutor(1, RenewInstanceService.createThreadFactory()));
    }

    public RenewInstanceService(RenewProperties renewProperties, ServiceRegistry serviceRegistry, ScheduledExecutorService scheduledExecutorService) {
        this.renewProperties = renewProperties;
        this.serviceRegistry = serviceRegistry;
        this.scheduledExecutorService = scheduledExecutorService;
    }

    public void start() {
        if (this.isRunning()) {
            return;
        }
        log.info("start.");
        this.running = true;
        this.scheduledExecutorService.scheduleAtFixedRate(this::renew, this.renewProperties.getInitialDelay(), this.renewProperties.getPeriod(), TimeUnit.SECONDS);
    }

    public boolean isRunning() {
        return this.running;
    }

    public void stop() {
        if (!this.running) {
            return;
        }
        log.info("stop.");
        this.running = false;
        this.scheduledExecutorService.shutdown();
    }

    private void renew() {
        Set<NamespacedServiceInstance> instances = this.serviceRegistry.getRegisteredEphemeralInstances();
        log.info("renew - instances size:{}.", (Object)instances.size());
        if (instances.isEmpty()) {
            return;
        }
        CompletableFuture[] renewFutures = new CompletableFuture[instances.size()];
        Iterator<NamespacedServiceInstance> instanceIterator = instances.iterator();
        for (int i = 0; i < renewFutures.length; ++i) {
            NamespacedServiceInstance namespacedServiceInstance = instanceIterator.next();
            renewFutures[i] = this.serviceRegistry.renew(namespacedServiceInstance.getNamespace(), namespacedServiceInstance.getServiceInstance());
        }
        CompletableFuture.allOf(renewFutures).join();
    }

    private static ThreadFactory createThreadFactory() {
        return new ThreadFactoryBuilder().setNameFormat(RenewInstanceService.class.getSimpleName() + "-%d").setDaemon(true).build();
    }
}

