/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.govern.discovery.redis;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import me.ahoo.govern.core.NamespacedContext;
import me.ahoo.govern.core.listener.ChannelTopic;
import me.ahoo.govern.core.listener.MessageListenable;
import me.ahoo.govern.core.listener.MessageListener;
import me.ahoo.govern.core.listener.PatternTopic;
import me.ahoo.govern.core.listener.Topic;
import me.ahoo.govern.core.util.RedisKeySpaces;
import me.ahoo.govern.discovery.DiscoveryKeyGenerator;
import me.ahoo.govern.discovery.Instance;
import me.ahoo.govern.discovery.InstanceIdGenerator;
import me.ahoo.govern.discovery.NamespacedServiceId;
import me.ahoo.govern.discovery.ServiceDiscovery;
import me.ahoo.govern.discovery.ServiceInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsistencyRedisServiceDiscovery
implements ServiceDiscovery {
    private static final Logger log = LoggerFactory.getLogger(ConsistencyRedisServiceDiscovery.class);
    private final ServiceDiscovery delegate;
    private final MessageListenable messageListenable;
    private final ServiceIdxListener serviceIdxListener;
    private final InstanceListener instanceListener;
    private final ConcurrentHashMap<NamespacedServiceId, CompletableFuture<List<ServiceInstance>>> serviceMapInstances = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, CompletableFuture<Set<String>>> namespaceMapServices = new ConcurrentHashMap();

    public ConsistencyRedisServiceDiscovery(ServiceDiscovery delegate, MessageListenable messageListenable) {
        this.delegate = delegate;
        this.messageListenable = messageListenable;
        this.serviceIdxListener = new ServiceIdxListener();
        this.instanceListener = new InstanceListener();
    }

    @Override
    public CompletableFuture<Set<String>> getServices(String namespace) {
        return this.namespaceMapServices.computeIfAbsent(namespace, _namespace -> {
            String serviceIdxKey = DiscoveryKeyGenerator.getServiceIdxKey(namespace);
            String topicStr = RedisKeySpaces.getTopicOfKey((String)serviceIdxKey);
            ChannelTopic serviceIdxTopic = ChannelTopic.of((String)topicStr);
            return this.messageListenable.addListener((Topic)serviceIdxTopic, (MessageListener)this.serviceIdxListener).thenCompose(nil -> this.delegate.getServices(namespace));
        });
    }

    @Override
    public CompletableFuture<Set<String>> getServices() {
        return this.getServices(NamespacedContext.GLOBAL.getNamespace());
    }

    @Override
    public CompletableFuture<List<ServiceInstance>> getInstances(String serviceId) {
        return this.getInstances(NamespacedContext.GLOBAL.getNamespace(), serviceId);
    }

    @Override
    public CompletableFuture<List<ServiceInstance>> getInstances(String namespace, String serviceId) {
        return this.serviceMapInstances.computeIfAbsent(NamespacedServiceId.of(namespace, serviceId), _serviceId -> this.addListener(namespace, serviceId).thenCompose(nil -> this.delegate.getInstances(serviceId)));
    }

    @VisibleForTesting
    public CompletableFuture<Void> addListener(String namespace, String serviceId) {
        PatternTopic instanceTopic = this.getPatternTopic(namespace, serviceId);
        return this.messageListenable.addListener((Topic)instanceTopic, (MessageListener)this.instanceListener);
    }

    @VisibleForTesting
    public Future<Void> removeListener(String namespace, String serviceId) {
        PatternTopic instanceTopic = this.getPatternTopic(namespace, serviceId);
        return this.messageListenable.removeListener((Topic)instanceTopic);
    }

    private PatternTopic getPatternTopic(String namespace, String serviceId) {
        String instancePattern = DiscoveryKeyGenerator.getInstanceKeyPatternOfService(namespace, serviceId);
        String topicStr = RedisKeySpaces.getTopicOfKey((String)instancePattern);
        PatternTopic instanceTopic = PatternTopic.of((String)topicStr);
        return instanceTopic;
    }

    private class InstanceListener
    implements MessageListener {
        private static final String MSG_EXPIRE = "expire";

        private InstanceListener() {
        }

        public void onMessage(Topic topic, String channel, String message) {
            if (log.isInfoEnabled()) {
                log.info("onMessage@InstanceListener - topic:[{}] - channel:[{}] - message:[{}]", new Object[]{topic, channel, message});
            }
            if (MSG_EXPIRE.equals(message)) {
                return;
            }
            String instanceKey = RedisKeySpaces.getKeyOfChannel((String)channel);
            String namespace = DiscoveryKeyGenerator.getNamespaceOfKey(instanceKey);
            String instanceId = DiscoveryKeyGenerator.getInstanceIdOfKey(namespace, instanceKey);
            Instance instance = InstanceIdGenerator.DEFAULT.of(instanceId);
            String serviceId = instance.getServiceId();
            ConsistencyRedisServiceDiscovery.this.serviceMapInstances.put(NamespacedServiceId.of(namespace, serviceId), ConsistencyRedisServiceDiscovery.this.delegate.getInstances(namespace, serviceId));
        }
    }

    private class ServiceIdxListener
    implements MessageListener {
        private ServiceIdxListener() {
        }

        public void onMessage(Topic topic, String channel, String message) {
            if (log.isInfoEnabled()) {
                log.info("onMessage@ServiceIdxListener - topic:[{}] - channel:[{}] - message:[{}]", new Object[]{topic, channel, message});
            }
            String serviceIdxKey = RedisKeySpaces.getKeyOfChannel((String)channel);
            String namespace = DiscoveryKeyGenerator.getNamespaceOfKey(serviceIdxKey);
            ConsistencyRedisServiceDiscovery.this.namespaceMapServices.put(namespace, ConsistencyRedisServiceDiscovery.this.delegate.getServices(namespace));
        }
    }
}

