/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.govern.discovery.redis;

import io.lettuce.core.RedisFuture;
import io.lettuce.core.ScriptOutputType;
import io.lettuce.core.cluster.api.async.RedisClusterAsyncCommands;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import me.ahoo.govern.discovery.DiscoveryKeyGenerator;
import me.ahoo.govern.discovery.ServiceDiscovery;
import me.ahoo.govern.discovery.ServiceInstance;
import me.ahoo.govern.discovery.ServiceInstanceCodec;
import me.ahoo.govern.discovery.redis.DiscoveryRedisScripts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisServiceDiscovery
implements ServiceDiscovery {
    private static final Logger log = LoggerFactory.getLogger(RedisServiceDiscovery.class);
    private final DiscoveryKeyGenerator keyGenerator;
    private final RedisClusterAsyncCommands<String, String> redisCommands;

    public RedisServiceDiscovery(DiscoveryKeyGenerator keyGenerator, RedisClusterAsyncCommands<String, String> redisCommands) {
        this.keyGenerator = keyGenerator;
        this.redisCommands = redisCommands;
    }

    @Override
    public CompletableFuture<List<ServiceInstance>> getInstances(String serviceId) {
        return ((CompletableFuture)DiscoveryRedisScripts.loadDiscoveryGetInstances(this.redisCommands).thenCompose(sha -> {
            RedisFuture redisFuture = this.redisCommands.evalsha(sha, ScriptOutputType.MULTI, (Object[])new String[]{this.keyGenerator.getNamespace(), serviceId});
            return redisFuture;
        })).thenApply(instanceGroups -> {
            if (Objects.isNull(instanceGroups)) {
                return Collections.emptyList();
            }
            ArrayList instances = new ArrayList(instanceGroups.size());
            instanceGroups.forEach(instanceData -> instances.add(ServiceInstanceCodec.decode(instanceData)));
            return instances;
        });
    }

    @Override
    public CompletableFuture<Set<String>> getServices() {
        String serviceIdxKey = this.keyGenerator.getServiceIdxKey();
        return this.redisCommands.smembers((Object)serviceIdxKey).toCompletableFuture();
    }

    public String getNamespace() {
        return this.keyGenerator.getNamespace();
    }
}

