/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.govern.discovery.redis;

import io.lettuce.core.RedisFuture;
import io.lettuce.core.ScriptOutputType;
import io.lettuce.core.cluster.api.async.RedisClusterAsyncCommands;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArraySet;
import me.ahoo.govern.discovery.DiscoveryKeyGenerator;
import me.ahoo.govern.discovery.RegistryProperties;
import me.ahoo.govern.discovery.ServiceInstance;
import me.ahoo.govern.discovery.ServiceInstanceCodec;
import me.ahoo.govern.discovery.ServiceRegistry;
import me.ahoo.govern.discovery.redis.DiscoveryRedisScripts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisServiceRegistry
implements ServiceRegistry {
    private static final Logger log = LoggerFactory.getLogger(RedisServiceRegistry.class);
    private final DiscoveryKeyGenerator keyGenerator;
    private final RegistryProperties registryProperties;
    private final RedisClusterAsyncCommands<String, String> redisCommands;
    private final CopyOnWriteArraySet<ServiceInstance> registeredEphemeralInstances = new CopyOnWriteArraySet();

    public RedisServiceRegistry(RegistryProperties registryProperties, DiscoveryKeyGenerator keyGenerator, RedisClusterAsyncCommands<String, String> redisCommands) {
        this.keyGenerator = keyGenerator;
        this.registryProperties = registryProperties;
        this.redisCommands = redisCommands;
    }

    private CompletableFuture<Boolean> register(String scriptSha, ServiceInstance serviceInstance) {
        Object[] keys = new String[]{this.keyGenerator.getNamespace(), serviceInstance.isEphemeral() ? String.valueOf(this.registryProperties.getInstanceTtl()) : "-1", serviceInstance.getServiceId(), serviceInstance.getInstanceId(), serviceInstance.getSchema(), serviceInstance.getIp(), String.valueOf(serviceInstance.getPort()), String.valueOf(serviceInstance.getWeight())};
        Object[] values = ServiceInstanceCodec.encodeMetadata(serviceInstance.getMetadata());
        RedisFuture redisFuture = this.redisCommands.evalsha(scriptSha, ScriptOutputType.BOOLEAN, keys, values);
        return redisFuture.toCompletableFuture();
    }

    @Override
    public CompletableFuture<Boolean> register(ServiceInstance serviceInstance) {
        if (log.isInfoEnabled()) {
            log.info("register - instanceId:[{}] .", (Object)serviceInstance.getInstanceId());
        }
        this.addEphemeralInstance(serviceInstance);
        return DiscoveryRedisScripts.loadRegistryRegister(this.redisCommands).thenCompose(sha -> this.register((String)sha, serviceInstance));
    }

    private void addEphemeralInstance(ServiceInstance serviceInstance) {
        if (!serviceInstance.isEphemeral()) {
            return;
        }
        this.registeredEphemeralInstances.add(serviceInstance);
    }

    private void removeEphemeralInstance(String instanceId) {
        Optional<ServiceInstance> serviceInstanceOp = this.registeredEphemeralInstances.stream().filter(instance -> instanceId.equals(instance.getInstanceId())).findFirst();
        if (serviceInstanceOp.isPresent()) {
            this.registeredEphemeralInstances.remove(serviceInstanceOp.get());
        }
    }

    private void removeEphemeralInstance(ServiceInstance serviceInstance) {
        if (!serviceInstance.isEphemeral()) {
            return;
        }
        this.registeredEphemeralInstances.remove(serviceInstance);
    }

    @Override
    public Set<ServiceInstance> getRegisteredEphemeralInstances() {
        return this.registeredEphemeralInstances;
    }

    @Override
    public CompletableFuture<Boolean> setMetadata(String serviceId, String instanceId, String key, String value) {
        if (log.isInfoEnabled()) {
            log.info("setMetadata - instanceId:[{}] .", (Object)instanceId);
        }
        String instanceKey = this.keyGenerator.getInstanceKey(instanceId);
        return this.redisCommands.hset((Object)instanceKey, (Object)key, (Object)value).toCompletableFuture();
    }

    @Override
    public CompletableFuture<Boolean> setMetadata(String serviceId, String instanceId, Map<String, String> metadata) {
        if (log.isInfoEnabled()) {
            log.info("setMetadata - instanceId:[{}] .", (Object)instanceId);
        }
        String instanceKey = this.keyGenerator.getInstanceKey(instanceId);
        return this.redisCommands.hset((Object)instanceKey, metadata).thenApply(setResult -> setResult > 0L).toCompletableFuture();
    }

    public CompletableFuture<Boolean> registerInstance(ServiceInstance serviceInstance) {
        if (log.isInfoEnabled()) {
            log.info("register - instanceId:[{}] .", (Object)serviceInstance.getInstanceId());
        }
        this.addEphemeralInstance(serviceInstance);
        return DiscoveryRedisScripts.loadRegistryRegisterInstance(this.redisCommands).thenCompose(sha -> this.register((String)sha, serviceInstance));
    }

    @Override
    public CompletableFuture<Boolean> renew(ServiceInstance serviceInstance) {
        if (log.isInfoEnabled()) {
            log.info("renew - instanceId:[{}] .", (Object)serviceInstance.getInstanceId());
        }
        if (!serviceInstance.isEphemeral()) {
            log.warn("renew - instanceId:[{}] is not ephemeral, can not renew.", (Object)serviceInstance.getInstanceId());
            return CompletableFuture.completedFuture(Boolean.FALSE);
        }
        String instanceIdKey = this.keyGenerator.getInstanceKey(serviceInstance.getInstanceId());
        return this.redisCommands.expire((Object)instanceIdKey, (long)this.registryProperties.getInstanceTtl()).toCompletableFuture();
    }

    @Override
    public CompletableFuture<Boolean> deregister(String serviceId, String instanceId) {
        if (log.isInfoEnabled()) {
            log.info("deregister - instanceId:[{}] .", (Object)instanceId);
        }
        this.removeEphemeralInstance(instanceId);
        return this.deregister0(serviceId, instanceId);
    }

    private CompletableFuture<Boolean> deregister0(String serviceId, String instanceId) {
        return DiscoveryRedisScripts.loadRegistryDeregister(this.redisCommands).thenCompose(sha -> {
            Object[] keys = new String[]{this.keyGenerator.getNamespace(), serviceId, instanceId};
            RedisFuture redisFuture = this.redisCommands.evalsha(sha, ScriptOutputType.BOOLEAN, keys);
            return redisFuture;
        });
    }

    @Override
    public CompletableFuture<Boolean> deregister(ServiceInstance serviceInstance) {
        if (log.isInfoEnabled()) {
            log.info("deregister - instanceId:[{}] .", (Object)serviceInstance.getInstanceId());
        }
        this.removeEphemeralInstance(serviceInstance);
        return this.deregister0(serviceInstance.getServiceId(), serviceInstance.getInstanceId());
    }

    public CompletableFuture<Long> registerServiceIdx(String serviceId) {
        if (log.isInfoEnabled()) {
            log.info("registerServiceIdx - serviceId:[{}] .", (Object)serviceId);
        }
        String serviceIdxKey = this.keyGenerator.getServiceIdxKey();
        return this.redisCommands.sadd((Object)serviceIdxKey, (Object[])new String[]{serviceId}).toCompletableFuture();
    }

    public CompletableFuture<Long> registerInstanceIdx(String serviceId, String instanceId) {
        if (log.isInfoEnabled()) {
            log.info("registerInstanceIdx - serviceId:[{}] - instanceId:[{}].", (Object)serviceId, (Object)instanceId);
        }
        String serviceInstanceIdxKey = this.keyGenerator.getInstanceIdxKey(serviceId);
        return this.redisCommands.sadd((Object)serviceInstanceIdxKey, (Object[])new String[]{instanceId}).toCompletableFuture();
    }
}

