/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.eventbus.spring.boot.autoconfigure.compensate;

import java.time.Duration;
import javax.sql.DataSource;
import me.ahoo.eventbus.core.compensate.CompensateConfig;
import me.ahoo.eventbus.core.compensate.PublishCompensateScheduler;
import me.ahoo.eventbus.core.compensate.SubscribeCompensateScheduler;
import me.ahoo.eventbus.core.consistency.ConsistencyPublisher;
import me.ahoo.eventbus.core.repository.PublishEventRepository;
import me.ahoo.eventbus.core.repository.SubscribeEventRepository;
import me.ahoo.eventbus.core.serialize.Deserializer;
import me.ahoo.eventbus.core.subscriber.SubscriberRegistry;
import me.ahoo.eventbus.spring.boot.autoconfigure.compensate.CompensateProperties;
import me.ahoo.eventbus.spring.boot.autoconfigure.compensate.ConditionalOnCompensateEnabled;
import me.ahoo.simba.core.MutexContendServiceFactory;
import me.ahoo.simba.jdbc.JdbcMutexContendServiceFactory;
import me.ahoo.simba.jdbc.JdbcMutexOwnerRepository;
import me.ahoo.simba.jdbc.MutexOwnerRepository;
import me.ahoo.simba.schedule.ScheduleConfig;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@EnableConfigurationProperties(value={CompensateProperties.class})
@ConditionalOnCompensateEnabled
public class CompensateAutoConfiguration {
    private CompensateProperties compensateProperties;

    public CompensateAutoConfiguration(CompensateProperties compensateProperties) {
        this.compensateProperties = compensateProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public MutexOwnerRepository mutexOwnerRepository(DataSource dataSource) {
        return new JdbcMutexOwnerRepository(dataSource);
    }

    @Bean
    @ConditionalOnMissingBean(name={"publishMutexContendServiceFactory"})
    public MutexContendServiceFactory publishMutexContendServiceFactory(MutexOwnerRepository mutexOwnerRepository) {
        return new JdbcMutexContendServiceFactory(mutexOwnerRepository, this.compensateProperties.getPublish().getDbMutex().getInitialDelay(), this.compensateProperties.getPublish().getDbMutex().getTtl(), this.compensateProperties.getPublish().getDbMutex().getTransition());
    }

    @Bean
    @ConditionalOnMissingBean(name={"subscribeMutexContendServiceFactory"})
    public MutexContendServiceFactory subscribeMutexContendServiceFactory(MutexOwnerRepository mutexOwnerRepository) {
        return new JdbcMutexContendServiceFactory(mutexOwnerRepository, this.compensateProperties.getSubscribe().getDbMutex().getInitialDelay(), this.compensateProperties.getSubscribe().getDbMutex().getTtl(), this.compensateProperties.getSubscribe().getDbMutex().getTransition());
    }

    @Bean
    @ConditionalOnMissingBean
    public PublishCompensateScheduler publishCompensateWorker(ConsistencyPublisher consistencyPublisher, PublishEventRepository publishEventRepository, @Qualifier(value="publishMutexContendServiceFactory") MutexContendServiceFactory publishMutexContendServiceFactory) {
        CompensateProperties.ScheduleConfig scheduleConfig = this.compensateProperties.getPublish().getSchedule();
        ScheduleConfig simbaScheduleCfg = ScheduleConfig.ofDelay((Duration)scheduleConfig.getInitialDelay(), (Duration)scheduleConfig.getPeriod());
        return new PublishCompensateScheduler((CompensateConfig)this.compensateProperties.getPublish(), simbaScheduleCfg, consistencyPublisher, publishEventRepository, publishMutexContendServiceFactory);
    }

    @Bean
    @ConditionalOnMissingBean
    public SubscribeCompensateScheduler subscribeCompensateWorker(Deserializer deserializer, SubscriberRegistry subscriberRegistry, SubscribeEventRepository subscribeEventRepository, @Qualifier(value="subscribeMutexContendServiceFactory") MutexContendServiceFactory subscribeMutexContendServiceFactory) {
        CompensateProperties.ScheduleConfig scheduleConfig = this.compensateProperties.getPublish().getSchedule();
        ScheduleConfig simbaScheduleCfg = ScheduleConfig.ofDelay((Duration)scheduleConfig.getInitialDelay(), (Duration)scheduleConfig.getPeriod());
        return new SubscribeCompensateScheduler((CompensateConfig)this.compensateProperties.getSubscribe(), simbaScheduleCfg, deserializer, subscriberRegistry, subscribeEventRepository, subscribeMutexContendServiceFactory);
    }
}

