/*
 * Copyright [2021-2021] [ahoo wang <ahoowang@qq.com> (https://github.com/Ahoo-Wang)].
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package me.ahoo.eventbus.spring.boot.autoconfigure.kafka;

import me.ahoo.eventbus.core.consistency.ConsistencySubscriberFactory;
import me.ahoo.eventbus.core.publisher.Publisher;
import me.ahoo.eventbus.core.serialize.Deserializer;
import me.ahoo.eventbus.core.serialize.Serializer;
import me.ahoo.eventbus.core.subscriber.SubscriberRegistry;
import me.ahoo.eventbus.kafka.KafkaEventCodec;
import me.ahoo.eventbus.kafka.KafkaPublisher;
import me.ahoo.eventbus.kafka.KafkaSubscriberRegistry;

import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.kafka.KafkaAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.kafka.config.KafkaListenerContainerFactory;
import org.springframework.kafka.config.KafkaListenerEndpointRegistry;
import org.springframework.kafka.core.KafkaTemplate;

/**
 * BusKafkaAutoConfiguration.
 *
 * @author ahoo wang
 */
@AutoConfigureAfter(KafkaAutoConfiguration.class)
@ConditionalOnClass(KafkaPublisher.class)
@EnableConfigurationProperties(KafkaProperties.class)
@ConditionalOnKafkaEnabled
public class BusKafkaAutoConfiguration {
    
    @Bean
    @ConditionalOnMissingBean
    public KafkaEventCodec eventCodec(Serializer serializer, Deserializer deserializer) {
        return new KafkaEventCodec(serializer, deserializer);
    }
    
    @Bean
    @ConditionalOnMissingBean
    public Publisher kafkaPublisher(KafkaEventCodec kafkaEventCodec,
                                    KafkaTemplate<Long, String> kafkaTemplate) {
        return new KafkaPublisher(kafkaEventCodec, kafkaTemplate);
    }
    
    @Bean
    @ConditionalOnMissingBean
    public SubscriberRegistry kafkaSubscriberRegistry(
        KafkaEventCodec kafkaEventCodec,
        ConsistencySubscriberFactory consistencySubscriberFactory,
        KafkaListenerEndpointRegistry listenerEndpointRegistry,
        KafkaListenerContainerFactory listenerContainerFactory) {
        return new KafkaSubscriberRegistry(kafkaEventCodec, consistencySubscriberFactory, listenerEndpointRegistry, listenerContainerFactory);
    }
}
