/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.eventbus.spring.boot.autoconfigure.compensate;

import java.time.Duration;
import me.ahoo.eventbus.core.compensate.CompensateConfig;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@ConfigurationProperties(value="govern.eventbus.compensate")
public class CompensateProperties {
    private boolean enabled = true;
    @NestedConfigurationProperty
    private Compensate publish = new Compensate();
    @NestedConfigurationProperty
    private Compensate subscribe = new Compensate();

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Compensate getPublish() {
        return this.publish;
    }

    public void setPublish(Compensate publish) {
        this.publish = publish;
    }

    public Compensate getSubscribe() {
        return this.subscribe;
    }

    public void setSubscribe(Compensate subscribe) {
        this.subscribe = subscribe;
    }

    public static class ScheduleConfig {
        private Duration initialDelay = Duration.ofSeconds(5L);
        private Duration period = Duration.ofMinutes(5L);

        public Duration getInitialDelay() {
            return this.initialDelay;
        }

        public void setInitialDelay(Duration initialDelay) {
            this.initialDelay = initialDelay;
        }

        public Duration getPeriod() {
            return this.period;
        }

        public void setPeriod(Duration period) {
            this.period = period;
        }
    }

    public static class DbMutex {
        public static final DbMutex DEFAULT = new DbMutex();
        private Duration initialDelay = Duration.ofSeconds(2L);
        private Duration ttl = Duration.ofSeconds(10L);
        private Duration transition = Duration.ofSeconds(2L);

        public Duration getInitialDelay() {
            return this.initialDelay;
        }

        public void setInitialDelay(Duration initialDelay) {
            this.initialDelay = initialDelay;
        }

        public Duration getTtl() {
            return this.ttl;
        }

        public void setTtl(Duration ttl) {
            this.ttl = ttl;
        }

        public Duration getTransition() {
            return this.transition;
        }

        public void setTransition(Duration transition) {
            this.transition = transition;
        }
    }

    public static class Compensate
    extends CompensateConfig {
        private DbMutex dbMutex = DbMutex.DEFAULT;
        private ScheduleConfig schedule = new ScheduleConfig();

        public DbMutex getDbMutex() {
            return this.dbMutex;
        }

        public void setDbMutex(DbMutex dbMutex) {
            this.dbMutex = dbMutex;
        }

        public ScheduleConfig getSchedule() {
            return this.schedule;
        }

        public void setSchedule(ScheduleConfig schedule) {
            this.schedule = schedule;
        }
    }
}

