package me.ahoo.eventbus.spring.boot.autoconfigure.compensation;

import me.ahoo.eventbus.core.compensation.PublishCompensation;
import me.ahoo.eventbus.core.compensation.SubscribeCompensation;
import me.ahoo.eventbus.core.compensation.impl.PublishCompensationImpl;
import me.ahoo.eventbus.core.compensation.impl.SubscribeCompensationImpl;
import me.ahoo.eventbus.core.consistency.ConsistencyPublisher;
import me.ahoo.eventbus.core.repository.PublishEventRepository;
import me.ahoo.eventbus.core.repository.SubscribeEventRepository;
import me.ahoo.eventbus.core.subscriber.SubscriberRegistry;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

/**
 * @author ahoo wang
 * create time 2020/5/14 22:42
 */
@EnableConfigurationProperties(CompensationProperties.class)
@ConditionalOnProperty(prefix = CompensationProperties.PREFIX, name = "enable", havingValue = "true", matchIfMissing = true)
public class CompensationAutoConfiguration {
    private CompensationProperties compensationProperties;

    public CompensationAutoConfiguration(CompensationProperties compensationProperties){
        this.compensationProperties = compensationProperties;
    }
    @Bean
    @ConditionalOnMissingBean
    public PublishCompensation publishCompensation(
            ConsistencyPublisher consistencyPublisher,
            PublishEventRepository publishEventRepository) {
        return new PublishCompensationImpl(compensationProperties.getPublish(), consistencyPublisher, publishEventRepository);
    }

    @Bean
    @ConditionalOnMissingBean
    public SubscribeCompensation subscribeCompensation(
            SubscriberRegistry subscriberRegistry,
            SubscribeEventRepository subscribeEventRepository) {
        return new SubscribeCompensationImpl(compensationProperties.getSubscribe(), subscriberRegistry, subscribeEventRepository);
    }
}
