/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.eventbus.spring.boot.autoconfigure;

import com.mydao.eventbus.spring.annotation.EnableEventBus;
import me.ahoo.eventbus.core.consistency.ConsistencyPublisher;
import me.ahoo.eventbus.core.consistency.ConsistencySubscriberFactory;
import me.ahoo.eventbus.core.consistency.impl.ConsistencyPublisherImpl;
import me.ahoo.eventbus.core.consistency.impl.ConsistencySubscriberFactoryImpl;
import me.ahoo.eventbus.core.publisher.EventDescriptorParser;
import me.ahoo.eventbus.core.publisher.EventNameGenerator;
import me.ahoo.eventbus.core.publisher.Publisher;
import me.ahoo.eventbus.core.publisher.impl.SimpleEventDescriptorParser;
import me.ahoo.eventbus.core.publisher.impl.SimpleEventNameGenerator;
import me.ahoo.eventbus.core.repository.PublishEventRepository;
import me.ahoo.eventbus.core.repository.SubscribeEventRepository;
import me.ahoo.eventbus.core.subscriber.SubscriberNameGenerator;
import me.ahoo.eventbus.core.subscriber.SubscriberScanner;
import me.ahoo.eventbus.core.subscriber.impl.SimpleSubscriberNameGenerator;
import me.ahoo.eventbus.jdbc.JdbcPublishEventRepository;
import me.ahoo.eventbus.jdbc.JdbcSubscribeEventRepository;
import me.ahoo.eventbus.spring.boot.autoconfigure.EventBusProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
@EnableEventBus
@EnableConfigurationProperties(value={EventBusProperties.class})
public class EventBusAutoConfiguration {
    private final EventBusProperties eventBusProperties;

    public EventBusAutoConfiguration(EventBusProperties eventBusProperties) {
        this.eventBusProperties = eventBusProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public EventNameGenerator eventNameGenerator() {
        return new SimpleEventNameGenerator();
    }

    @Bean
    @ConditionalOnMissingBean
    public SubscriberNameGenerator subscriberNameGenerator() {
        return new SimpleSubscriberNameGenerator(this.eventBusProperties.getSubscriber().getPrefix());
    }

    @Bean
    @ConditionalOnMissingBean
    public EventDescriptorParser eventDescriptorParser(EventNameGenerator eventNameGenerator) {
        return new SimpleEventDescriptorParser(eventNameGenerator);
    }

    @Bean
    @ConditionalOnMissingBean
    public SubscriberScanner subscriberScanner(SubscriberNameGenerator subscriberNameGenerator, EventDescriptorParser eventDescriptorParser) {
        return new SubscriberScanner(subscriberNameGenerator, eventDescriptorParser);
    }

    @Bean
    @ConditionalOnMissingBean
    public PublishEventRepository publishEventRepository(NamedParameterJdbcTemplate jdbcTemplate) {
        return new JdbcPublishEventRepository(jdbcTemplate);
    }

    @Bean
    @ConditionalOnMissingBean
    public SubscribeEventRepository subscribeEventRepository(NamedParameterJdbcTemplate jdbcTemplate) {
        return new JdbcSubscribeEventRepository(jdbcTemplate);
    }

    @Bean
    @ConditionalOnMissingBean
    public ConsistencyPublisher consistencyPublisher(Publisher publisher, EventDescriptorParser eventDescriptorParser, PublishEventRepository publishEventRepository, PlatformTransactionManager transactionManager) {
        return new ConsistencyPublisherImpl(publisher, eventDescriptorParser, publishEventRepository, transactionManager);
    }

    @Bean
    @ConditionalOnMissingBean
    public ConsistencySubscriberFactory consistencySubscriberFactory(ConsistencyPublisher consistencyPublisher, EventDescriptorParser eventDescriptorParser, PublishEventRepository publishEventRepository, SubscribeEventRepository subscribeEventRepository, PlatformTransactionManager transactionManager) {
        return new ConsistencySubscriberFactoryImpl(consistencyPublisher, eventDescriptorParser, publishEventRepository, subscribeEventRepository, transactionManager);
    }
}

