package me.ahoo.eventbus.spring.boot.autoconfigure;

import lombok.Data;
import me.ahoo.eventbus.core.compensation.impl.config.PublishConfig;
import me.ahoo.eventbus.core.compensation.impl.config.SubscribeConfig;
import me.ahoo.eventbus.rabbit.config.RabbitConfig;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

/**
 * @author : ahoo wang
 */
@Data
@ConfigurationProperties(EventBusProperties.PREFIX)
public class EventBusProperties {
    public static final String PREFIX = "ahoo.eventbus";
    @NestedConfigurationProperty
    private Subscriber subscriber;

    public EventBusProperties() {
        subscriber = new Subscriber();
    }

    @Data
    public static class Subscriber {
        private String prefix;
    }
}
