/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.eventbus.spring.boot.autoconfigure.kafka;

import me.ahoo.eventbus.core.consistency.ConsistencySubscriberFactory;
import me.ahoo.eventbus.core.publisher.Publisher;
import me.ahoo.eventbus.core.subscriber.SubscriberRegistry;
import me.ahoo.eventbus.kafka.KafkaPublisher;
import me.ahoo.eventbus.kafka.KafkaSubscriberRegistry;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.kafka.KafkaAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.kafka.config.KafkaListenerContainerFactory;
import org.springframework.kafka.config.KafkaListenerEndpointRegistry;
import org.springframework.kafka.core.KafkaTemplate;

@AutoConfigureAfter(value={KafkaAutoConfiguration.class})
@ConditionalOnClass(value={KafkaPublisher.class})
public class BusKafkaAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public Publisher publisher(KafkaTemplate kafkaTemplate) {
        return new KafkaPublisher(kafkaTemplate);
    }

    @Bean
    @ConditionalOnMissingBean
    public SubscriberRegistry subscribeContainer(ConsistencySubscriberFactory consistencySubscriberFactory, KafkaListenerEndpointRegistry listenerEndpointRegistry, KafkaListenerContainerFactory listenerContainerFactory) {
        return new KafkaSubscriberRegistry(consistencySubscriberFactory, listenerEndpointRegistry, listenerContainerFactory);
    }
}

