package me.ahoo.eventbus.spring.boot.autoconfigure.compensation;

import lombok.Data;
import me.ahoo.eventbus.core.compensation.impl.config.PublishConfig;
import me.ahoo.eventbus.core.compensation.impl.config.SubscribeConfig;
import me.ahoo.eventbus.spring.boot.autoconfigure.EventBusProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

/**
 * @author ahoo wang
 * create time 2020/5/14 22:43
 */
@Data
@ConfigurationProperties(CompensationProperties.PREFIX)
public class CompensationProperties {
    public static final String PREFIX = EventBusProperties.PREFIX + ".compensation";
    private boolean enable = true;
    @NestedConfigurationProperty
    private PublishConfig publish;
    @NestedConfigurationProperty
    private SubscribeConfig subscribe;

    public CompensationProperties() {
        publish = new PublishConfig();
        subscribe = new SubscribeConfig();
    }
}
