/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.spring.boot.starter;

import java.util.Objects;
import me.ahoo.cosid.MachineIdDistributor;
import me.ahoo.cosid.k8s.StatefulSetMachineIdDistributor;
import me.ahoo.cosid.snowflake.MillisecondSnowflakeId;
import me.ahoo.cosid.snowflake.MillisecondSnowflakeIdStateParser;
import me.ahoo.cosid.snowflake.SnowflakeId;
import me.ahoo.cosid.spring.boot.starter.ConditionalOnCosIdEnabled;
import me.ahoo.cosid.spring.boot.starter.CosIdProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration(proxyBeanMethods=false)
@ConditionalOnCosIdEnabled
@EnableConfigurationProperties(value={CosIdProperties.class})
public class CosIdAutoConfiguration {
    private final CosIdProperties cosIdProperties;

    public CosIdAutoConfiguration(CosIdProperties cosIdProperties) {
        this.cosIdProperties = cosIdProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public MachineIdDistributor machineIdDistributor() {
        if (Objects.nonNull(this.cosIdProperties) && Objects.nonNull(this.cosIdProperties.getSnowflake())) {
            Integer machineId = this.cosIdProperties.getSnowflake().getMachineId();
            return new MachineIdDistributor.DefaultMachineIdDistributor(machineId.intValue());
        }
        return StatefulSetMachineIdDistributor.INSTANCE;
    }

    @Primary
    @Bean
    @ConditionalOnMissingBean
    public MillisecondSnowflakeId idGenerator(MachineIdDistributor machineIdDistributor) {
        Integer machineId = machineIdDistributor.distribute();
        return new MillisecondSnowflakeId(machineId.intValue());
    }

    @Bean
    @ConditionalOnBean(value={MillisecondSnowflakeId.class})
    public MillisecondSnowflakeIdStateParser millisecondSnowflakeIdStateParser(MillisecondSnowflakeId millisecondSnowflakeId) {
        return MillisecondSnowflakeIdStateParser.of((SnowflakeId)millisecondSnowflakeId);
    }
}

