/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosec.servlet;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.cosec.api.context.SecurityContext;
import me.ahoo.cosec.api.context.request.Request;
import me.ahoo.cosec.context.RequestSecurityContexts;
import me.ahoo.cosec.context.SecurityContextHolder;
import me.ahoo.cosec.context.SecurityContextParser;
import me.ahoo.cosec.context.request.RequestParser;
import me.ahoo.cosec.servlet.ServletRequests;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lme/ahoo/cosec/servlet/InjectSecurityContextFilter;", "Ljakarta/servlet/Filter;", "requestParser", "Lme/ahoo/cosec/context/request/RequestParser;", "Ljakarta/servlet/http/HttpServletRequest;", "securityContextParser", "Lme/ahoo/cosec/context/SecurityContextParser;", "<init>", "(Lme/ahoo/cosec/context/request/RequestParser;Lme/ahoo/cosec/context/SecurityContextParser;)V", "doFilter", "", "servletRequest", "Ljakarta/servlet/ServletRequest;", "servletResponse", "Ljakarta/servlet/ServletResponse;", "filterChain", "Ljakarta/servlet/FilterChain;", "tryInjectSecurityContext", "cosec-webmvc"})
public final class InjectSecurityContextFilter
implements Filter {
    @NotNull
    private final RequestParser<HttpServletRequest> requestParser;
    @NotNull
    private final SecurityContextParser securityContextParser;

    public InjectSecurityContextFilter(@NotNull RequestParser<HttpServletRequest> requestParser, @NotNull SecurityContextParser securityContextParser) {
        Intrinsics.checkNotNullParameter(requestParser, (String)"requestParser");
        Intrinsics.checkNotNullParameter((Object)securityContextParser, (String)"securityContextParser");
        this.requestParser = requestParser;
        this.securityContextParser = securityContextParser;
    }

    public void doFilter(@NotNull ServletRequest servletRequest, @NotNull ServletResponse servletResponse, @NotNull FilterChain filterChain) throws IOException, ServletException {
        Intrinsics.checkNotNullParameter((Object)servletRequest, (String)"servletRequest");
        Intrinsics.checkNotNullParameter((Object)servletResponse, (String)"servletResponse");
        Intrinsics.checkNotNullParameter((Object)filterChain, (String)"filterChain");
        this.tryInjectSecurityContext(servletRequest);
        filterChain.doFilter(servletRequest, servletResponse);
    }

    private final void tryInjectSecurityContext(ServletRequest servletRequest) {
        Intrinsics.checkNotNull((Object)servletRequest, (String)"null cannot be cast to non-null type jakarta.servlet.http.HttpServletRequest");
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        Request request = this.requestParser.parse((Object)servletRequest);
        SecurityContext securityContext = this.securityContextParser.ensureParse(request);
        RequestSecurityContexts.INSTANCE.setRequest(securityContext, request);
        SecurityContextHolder.setContext((SecurityContext)securityContext);
        ServletRequests.INSTANCE.setSecurityContext(httpServletRequest, securityContext);
    }
}

