/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosec.servlet;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import me.ahoo.cosec.api.authorization.Authorization;
import me.ahoo.cosec.api.authorization.AuthorizeResult;
import me.ahoo.cosec.api.context.SecurityContext;
import me.ahoo.cosec.api.context.request.Request;
import me.ahoo.cosec.context.RequestSecurityContexts;
import me.ahoo.cosec.context.SecurityContextHolder;
import me.ahoo.cosec.context.SecurityContextParser;
import me.ahoo.cosec.context.SimpleSecurityContext;
import me.ahoo.cosec.context.request.RequestParser;
import me.ahoo.cosec.serialization.CoSecJsonSerializer;
import me.ahoo.cosec.servlet.ServletRequests;
import me.ahoo.cosec.token.TokenVerificationException;
import me.ahoo.cosec.token.TokenVerificationExceptionKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.HttpStatus;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B)\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0004J\u0012\u0010\u000f\u001a\u00020\u0010*\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lme/ahoo/cosec/servlet/AbstractAuthorizationInterceptor;", "", "requestParser", "Lme/ahoo/cosec/context/request/RequestParser;", "Ljakarta/servlet/http/HttpServletRequest;", "securityContextParser", "Lme/ahoo/cosec/context/SecurityContextParser;", "authorization", "Lme/ahoo/cosec/api/authorization/Authorization;", "(Lme/ahoo/cosec/context/request/RequestParser;Lme/ahoo/cosec/context/SecurityContextParser;Lme/ahoo/cosec/api/authorization/Authorization;)V", "authorize", "", "servletRequest", "servletResponse", "Ljakarta/servlet/http/HttpServletResponse;", "writeWithAuthorizeResult", "", "authorizeResult", "Lme/ahoo/cosec/api/authorization/AuthorizeResult;", "cosec-webmvc"})
public abstract class AbstractAuthorizationInterceptor {
    @NotNull
    private final RequestParser<HttpServletRequest> requestParser;
    @NotNull
    private final SecurityContextParser<HttpServletRequest> securityContextParser;
    @NotNull
    private final Authorization authorization;

    public AbstractAuthorizationInterceptor(@NotNull RequestParser<HttpServletRequest> requestParser, @NotNull SecurityContextParser<HttpServletRequest> securityContextParser, @NotNull Authorization authorization) {
        Intrinsics.checkNotNullParameter(requestParser, (String)"requestParser");
        Intrinsics.checkNotNullParameter(securityContextParser, (String)"securityContextParser");
        Intrinsics.checkNotNullParameter((Object)authorization, (String)"authorization");
        this.requestParser = requestParser;
        this.securityContextParser = securityContextParser;
        this.authorization = authorization;
    }

    protected final boolean authorize(@NotNull HttpServletRequest servletRequest, @NotNull HttpServletResponse servletResponse) {
        SecurityContext securityContext;
        Intrinsics.checkNotNullParameter((Object)servletRequest, (String)"servletRequest");
        Intrinsics.checkNotNullParameter((Object)servletResponse, (String)"servletResponse");
        Ref.ObjectRef tokenVerificationException = new Ref.ObjectRef();
        try {
            securityContext = this.securityContextParser.parse((Object)servletRequest);
        }
        catch (TokenVerificationException verificationException) {
            tokenVerificationException.element = verificationException;
            securityContext = SimpleSecurityContext.Companion.anonymous();
        }
        SecurityContext securityContext2 = securityContext;
        SecurityContextHolder.setContext((SecurityContext)securityContext2);
        ServletRequests.INSTANCE.setSecurityContext(servletRequest, securityContext2);
        Request request = this.requestParser.parse((Object)servletRequest);
        RequestSecurityContexts.INSTANCE.setRequest(securityContext2, request);
        Object object = this.authorization.authorize(request, securityContext2).map(arg_0 -> AbstractAuthorizationInterceptor.authorize$lambda$0((Function1)new Function1<AuthorizeResult, Boolean>(securityContext2, servletResponse, this, (Ref.ObjectRef<TokenVerificationException>)tokenVerificationException){
            final /* synthetic */ SecurityContext $securityContext;
            final /* synthetic */ HttpServletResponse $servletResponse;
            final /* synthetic */ AbstractAuthorizationInterceptor this$0;
            final /* synthetic */ Ref.ObjectRef<TokenVerificationException> $tokenVerificationException;
            {
                this.$securityContext = $securityContext;
                this.$servletResponse = $servletResponse;
                this.this$0 = $receiver;
                this.$tokenVerificationException = $tokenVerificationException;
                super(1);
            }

            public final Boolean invoke(AuthorizeResult it) {
                if (!it.getAuthorized()) {
                    TokenVerificationException tokenVerificationException;
                    if (!this.$securityContext.getPrincipal().authenticated()) {
                        this.$servletResponse.setStatus(HttpStatus.UNAUTHORIZED.value());
                    } else {
                        this.$servletResponse.setStatus(HttpStatus.FORBIDDEN.value());
                    }
                    if ((tokenVerificationException = (TokenVerificationException)((Object)this.$tokenVerificationException.element)) == null || (tokenVerificationException = TokenVerificationExceptionKt.asAuthorizeResult((TokenVerificationException)tokenVerificationException)) == null) {
                        tokenVerificationException = it;
                    }
                    TokenVerificationException tokenVerificationException2 = tokenVerificationException;
                    Intrinsics.checkNotNull((Object)((Object)tokenVerificationException2));
                    this.this$0.writeWithAuthorizeResult(this.$servletResponse, (AuthorizeResult)tokenVerificationException2);
                    return false;
                }
                return true;
            }
        }, arg_0)).block();
        Intrinsics.checkNotNull((Object)object);
        return (Boolean)object;
    }

    public final void writeWithAuthorizeResult(@NotNull HttpServletResponse $this$writeWithAuthorizeResult, @NotNull AuthorizeResult authorizeResult) {
        Intrinsics.checkNotNullParameter((Object)$this$writeWithAuthorizeResult, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)authorizeResult, (String)"authorizeResult");
        $this$writeWithAuthorizeResult.setContentType("application/json");
        $this$writeWithAuthorizeResult.getOutputStream().write(CoSecJsonSerializer.INSTANCE.writeValueAsBytes((Object)authorizeResult));
        $this$writeWithAuthorizeResult.getOutputStream().flush();
    }

    private static final Boolean authorize$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

