/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosec.servlet;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.cosec.api.authorization.Authorization;
import me.ahoo.cosec.api.authorization.AuthorizeResult;
import me.ahoo.cosec.context.SecurityContextParser;
import me.ahoo.cosec.context.request.RequestParser;
import me.ahoo.cosec.policy.condition.limiter.TooManyRequestsException;
import me.ahoo.cosec.servlet.AbstractAuthorizationInterceptor;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.HttpStatus;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B)\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\u0002\u0010\nJ \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0013"}, d2={"Lme/ahoo/cosec/servlet/AuthorizationFilter;", "Lme/ahoo/cosec/servlet/AbstractAuthorizationInterceptor;", "Ljakarta/servlet/Filter;", "securityContextParser", "Lme/ahoo/cosec/context/SecurityContextParser;", "Ljakarta/servlet/http/HttpServletRequest;", "authorization", "Lme/ahoo/cosec/api/authorization/Authorization;", "requestParser", "Lme/ahoo/cosec/context/request/RequestParser;", "(Lme/ahoo/cosec/context/SecurityContextParser;Lme/ahoo/cosec/api/authorization/Authorization;Lme/ahoo/cosec/context/request/RequestParser;)V", "doFilter", "", "request", "Ljakarta/servlet/ServletRequest;", "response", "Ljakarta/servlet/ServletResponse;", "chain", "Ljakarta/servlet/FilterChain;", "cosec-webmvc"})
public final class AuthorizationFilter
extends AbstractAuthorizationInterceptor
implements Filter {
    public AuthorizationFilter(@NotNull SecurityContextParser<HttpServletRequest> securityContextParser, @NotNull Authorization authorization, @NotNull RequestParser<HttpServletRequest> requestParser) {
        Intrinsics.checkNotNullParameter(securityContextParser, (String)"securityContextParser");
        Intrinsics.checkNotNullParameter((Object)authorization, (String)"authorization");
        Intrinsics.checkNotNullParameter(requestParser, (String)"requestParser");
        super(requestParser, securityContextParser, authorization);
    }

    public void doFilter(@NotNull ServletRequest request, @NotNull ServletResponse response, @NotNull FilterChain chain) throws IOException, ServletException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        try {
            if (this.authorize(httpServletRequest, httpServletResponse)) {
                chain.doFilter(request, response);
            }
        }
        catch (TooManyRequestsException tooManyRequestsException) {
            ((HttpServletResponse)response).setStatus(HttpStatus.TOO_MANY_REQUESTS.value());
            this.writeWithAuthorizeResult(httpServletResponse, AuthorizeResult.Companion.getTOO_MANY_REQUESTS());
        }
    }
}

