/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosec.servlet;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.cosec.api.authorization.Authorization;
import me.ahoo.cosec.api.authorization.AuthorizeResult;
import me.ahoo.cosec.api.context.SecurityContext;
import me.ahoo.cosec.context.SecurityContextHolder;
import me.ahoo.cosec.context.SecurityContextParser;
import me.ahoo.cosec.context.request.RequestParser;
import me.ahoo.cosec.policy.serialization.CoSecJsonSerializer;
import me.ahoo.cosec.servlet.ServletRequests;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB)\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0004R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lme/ahoo/cosec/servlet/AbstractAuthorizationInterceptor;", "", "requestParser", "Lme/ahoo/cosec/context/request/RequestParser;", "Ljavax/servlet/http/HttpServletRequest;", "securityContextParser", "Lme/ahoo/cosec/context/SecurityContextParser;", "authorization", "Lme/ahoo/cosec/api/authorization/Authorization;", "(Lme/ahoo/cosec/context/request/RequestParser;Lme/ahoo/cosec/context/SecurityContextParser;Lme/ahoo/cosec/api/authorization/Authorization;)V", "authorize", "", "request", "response", "Ljavax/servlet/http/HttpServletResponse;", "Companion", "cosec-webmvc"})
public abstract class AbstractAuthorizationInterceptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RequestParser<HttpServletRequest> requestParser;
    @NotNull
    private final SecurityContextParser<HttpServletRequest> securityContextParser;
    @NotNull
    private final Authorization authorization;
    private static final Logger log = LoggerFactory.getLogger(AbstractAuthorizationInterceptor.class);

    public AbstractAuthorizationInterceptor(@NotNull RequestParser<HttpServletRequest> requestParser, @NotNull SecurityContextParser<HttpServletRequest> securityContextParser, @NotNull Authorization authorization) {
        Intrinsics.checkNotNullParameter(requestParser, (String)"requestParser");
        Intrinsics.checkNotNullParameter(securityContextParser, (String)"securityContextParser");
        Intrinsics.checkNotNullParameter((Object)authorization, (String)"authorization");
        this.requestParser = requestParser;
        this.securityContextParser = securityContextParser;
        this.authorization = authorization;
    }

    protected final boolean authorize(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        SecurityContext securityContext = null;
        try {
            securityContext = this.securityContextParser.parse((Object)request);
        }
        catch (Throwable throwable) {
            if (log.isInfoEnabled()) {
                log.info(throwable.getMessage(), throwable);
            }
            response.setStatus(HttpStatus.UNAUTHORIZED.value());
            return false;
        }
        SecurityContextHolder.setContext((SecurityContext)securityContext);
        ServletRequests.INSTANCE.setSecurityContext(request, securityContext);
        Object object = this.authorization.authorize(this.requestParser.parse((Object)request), securityContext).map(arg_0 -> AbstractAuthorizationInterceptor.authorize$lambda$0((Function1)new Function1<AuthorizeResult, Boolean>(securityContext, response){
            final /* synthetic */ SecurityContext $securityContext;
            final /* synthetic */ HttpServletResponse $response;
            {
                this.$securityContext = $securityContext;
                this.$response = $response;
                super(1);
            }

            public final Boolean invoke(AuthorizeResult it) {
                if (!it.getAuthorized()) {
                    if (!this.$securityContext.getPrincipal().authenticated()) {
                        this.$response.setStatus(HttpStatus.UNAUTHORIZED.value());
                    } else {
                        this.$response.setStatus(HttpStatus.FORBIDDEN.value());
                    }
                    this.$response.getOutputStream().write(CoSecJsonSerializer.INSTANCE.writeValueAsBytes((Object)it));
                    this.$response.getOutputStream().flush();
                    return false;
                }
                return true;
            }
        }, arg_0)).block();
        Intrinsics.checkNotNull((Object)object);
        return (Boolean)object;
    }

    private static final Boolean authorize$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lme/ahoo/cosec/servlet/AbstractAuthorizationInterceptor$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "cosec-webmvc"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

