/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosec.spring.boot.starter.authorization;

import jakarta.servlet.http.HttpServletRequest;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.cosec.api.authorization.Authorization;
import me.ahoo.cosec.authorization.AppRolePermissionRepository;
import me.ahoo.cosec.authorization.PolicyRepository;
import me.ahoo.cosec.authorization.SimpleAuthorization;
import me.ahoo.cosec.context.DefaultSecurityContextParser;
import me.ahoo.cosec.context.SecurityContextParser;
import me.ahoo.cosec.context.request.RequestParser;
import me.ahoo.cosec.policy.LocalPolicyInitializer;
import me.ahoo.cosec.policy.LocalPolicyLoader;
import me.ahoo.cosec.servlet.AuthorizationFilter;
import me.ahoo.cosec.spring.boot.starter.ConditionalOnCoSecEnabled;
import me.ahoo.cosec.spring.boot.starter.authorization.AuthorizationProperties;
import me.ahoo.cosec.spring.boot.starter.authorization.ConditionalOnAuthorizationEnabled;
import me.ahoo.cosec.token.PrincipalConverter;
import me.ahoo.cosec.token.TokenVerifier;
import me.ahoo.cosec.webflux.ReactiveAuthorizationFilter;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.server.ServerWebExchange;

@AutoConfiguration
@ConditionalOnCoSecEnabled
@ConditionalOnAuthorizationEnabled
@EnableConfigurationProperties(value={AuthorizationProperties.class})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001:\u0002\u0014\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0017J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0017J \u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0017J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0017\u00a8\u0006\u0016"}, d2={"Lme/ahoo/cosec/spring/boot/starter/authorization/CoSecAuthorizationAutoConfiguration;", "", "<init>", "()V", "securityContextParser", "Lme/ahoo/cosec/context/SecurityContextParser;", "tokenVerifier", "Lme/ahoo/cosec/token/TokenVerifier;", "localPolicyLoader", "Lme/ahoo/cosec/policy/LocalPolicyLoader;", "authorizationProperties", "Lme/ahoo/cosec/spring/boot/starter/authorization/AuthorizationProperties;", "localPolicyInitializer", "Lme/ahoo/cosec/policy/LocalPolicyInitializer;", "policyRepository", "Lme/ahoo/cosec/authorization/PolicyRepository;", "cosecAuthorization", "Lme/ahoo/cosec/api/authorization/Authorization;", "appRolePermissionRepository", "Lme/ahoo/cosec/authorization/AppRolePermissionRepository;", "WebMvc", "WebFlux", "cosec-spring-boot-starter"})
public class CoSecAuthorizationAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public SecurityContextParser securityContextParser(@NotNull TokenVerifier tokenVerifier) {
        Intrinsics.checkNotNullParameter((Object)tokenVerifier, (String)"tokenVerifier");
        return (SecurityContextParser)new DefaultSecurityContextParser((PrincipalConverter)tokenVerifier);
    }

    @Bean
    @ConditionalOnProperty(value={"cosec.authorization.local-policy.enabled"}, havingValue="true", matchIfMissing=false)
    @NotNull
    public LocalPolicyLoader localPolicyLoader(@NotNull AuthorizationProperties authorizationProperties) {
        Intrinsics.checkNotNullParameter((Object)authorizationProperties, (String)"authorizationProperties");
        return new LocalPolicyLoader(authorizationProperties.getLocalPolicy().getLocations());
    }

    @Bean(initMethod="init")
    @ConditionalOnProperty(value={"cosec.authorization.local-policy.init-repository"}, havingValue="true", matchIfMissing=false)
    @NotNull
    public LocalPolicyInitializer localPolicyInitializer(@NotNull LocalPolicyLoader localPolicyLoader, @NotNull PolicyRepository policyRepository, @NotNull AuthorizationProperties authorizationProperties) {
        Intrinsics.checkNotNullParameter((Object)localPolicyLoader, (String)"localPolicyLoader");
        Intrinsics.checkNotNullParameter((Object)policyRepository, (String)"policyRepository");
        Intrinsics.checkNotNullParameter((Object)authorizationProperties, (String)"authorizationProperties");
        return new LocalPolicyInitializer(localPolicyLoader, policyRepository, authorizationProperties.getLocalPolicy().getForceRefresh());
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public Authorization cosecAuthorization(@NotNull PolicyRepository policyRepository, @NotNull AppRolePermissionRepository appRolePermissionRepository) {
        Intrinsics.checkNotNullParameter((Object)policyRepository, (String)"policyRepository");
        Intrinsics.checkNotNullParameter((Object)appRolePermissionRepository, (String)"appRolePermissionRepository");
        return (Authorization)new SimpleAuthorization(policyRepository, appRolePermissionRepository);
    }

    @Configuration
    @ConditionalOnClass(name={"me.ahoo.cosec.webflux.ReactiveAuthorizationFilter"})
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u000e\b\u0001\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0017\u00a8\u0006\r"}, d2={"Lme/ahoo/cosec/spring/boot/starter/authorization/CoSecAuthorizationAutoConfiguration$WebFlux;", "", "<init>", "()V", "reactiveAuthorizationFilter", "Lme/ahoo/cosec/webflux/ReactiveAuthorizationFilter;", "securityContextParser", "Lme/ahoo/cosec/context/SecurityContextParser;", "requestParser", "Lme/ahoo/cosec/context/request/RequestParser;", "Lorg/springframework/web/server/ServerWebExchange;", "authorization", "Lme/ahoo/cosec/api/authorization/Authorization;", "cosec-spring-boot-starter"})
    public static class WebFlux {
        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnMissingClass(value={"org.springframework.cloud.gateway.filter.GlobalFilter"})
        @NotNull
        public ReactiveAuthorizationFilter reactiveAuthorizationFilter(@NotNull SecurityContextParser securityContextParser, @Qualifier(value="reactiveRequestParser") @NotNull RequestParser<ServerWebExchange> requestParser, @NotNull Authorization authorization) {
            Intrinsics.checkNotNullParameter((Object)securityContextParser, (String)"securityContextParser");
            Intrinsics.checkNotNullParameter(requestParser, (String)"requestParser");
            Intrinsics.checkNotNullParameter((Object)authorization, (String)"authorization");
            return new ReactiveAuthorizationFilter(securityContextParser, requestParser, authorization);
        }
    }

    @Configuration
    @ConditionalOnClass(name={"me.ahoo.cosec.servlet.AuthorizationFilter"})
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u000e\b\u0001\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0017\u00a8\u0006\r"}, d2={"Lme/ahoo/cosec/spring/boot/starter/authorization/CoSecAuthorizationAutoConfiguration$WebMvc;", "", "<init>", "()V", "authorizationFilter", "Lme/ahoo/cosec/servlet/AuthorizationFilter;", "securityContextParser", "Lme/ahoo/cosec/context/SecurityContextParser;", "authorization", "Lme/ahoo/cosec/api/authorization/Authorization;", "requestParser", "Lme/ahoo/cosec/context/request/RequestParser;", "Ljakarta/servlet/http/HttpServletRequest;", "cosec-spring-boot-starter"})
    public static class WebMvc {
        @Bean
        @ConditionalOnMissingBean
        @NotNull
        public AuthorizationFilter authorizationFilter(@NotNull SecurityContextParser securityContextParser, @NotNull Authorization authorization, @Qualifier(value="servletRequestParser") @NotNull RequestParser<HttpServletRequest> requestParser) {
            Intrinsics.checkNotNullParameter((Object)securityContextParser, (String)"securityContextParser");
            Intrinsics.checkNotNullParameter((Object)authorization, (String)"authorization");
            Intrinsics.checkNotNullParameter(requestParser, (String)"requestParser");
            return new AuthorizationFilter(securityContextParser, authorization, requestParser);
        }
    }
}

