/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosec.spring.boot.starter.authorization.cache;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.cache.Cache;
import me.ahoo.cache.CacheConfig;
import me.ahoo.cache.CacheManager;
import me.ahoo.cache.CacheSource;
import me.ahoo.cache.CoherentCache;
import me.ahoo.cache.converter.KeyConverter;
import me.ahoo.cache.converter.ToStringKeyConverter;
import me.ahoo.cache.distributed.DistributedCache;
import me.ahoo.cache.spring.redis.RedisDistributedCache;
import me.ahoo.cache.spring.redis.codec.CodecExecutor;
import me.ahoo.cache.spring.redis.codec.ObjectToJsonCodecExecutor;
import me.ahoo.cache.spring.redis.codec.SetToSetCodecExecutor;
import me.ahoo.cache.util.ClientIdGenerator;
import me.ahoo.cosec.api.permission.AppPermission;
import me.ahoo.cosec.authorization.AppRolePermissionRepository;
import me.ahoo.cosec.redis.AppPermissionCache;
import me.ahoo.cosec.redis.RedisAppRolePermissionRepository;
import me.ahoo.cosec.redis.RolePermissionCache;
import me.ahoo.cosec.serialization.CoSecJsonSerializer;
import me.ahoo.cosec.spring.boot.starter.ConditionalOnCoSecEnabled;
import me.ahoo.cosec.spring.boot.starter.authorization.cache.CacheProperties;
import me.ahoo.cosec.spring.boot.starter.authorization.cache.ConditionalOnCacheEnabled;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.core.StringRedisTemplate;

@AutoConfiguration
@ConditionalOnCoSecEnabled
@ConditionalOnCacheEnabled
@ConditionalOnClass(name={"me.ahoo.cosec.redis.AppPermissionCache"})
@EnableConfigurationProperties(value={CacheProperties.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J6\u0010\u0005\u001a\u00020\u00062\u0014\b\u0001\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u0014\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bH\u0017J<\u0010\u0012\u001a\u00020\u00132\u001a\b\u0001\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00140\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u001a\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00140\bH\u0017J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lme/ahoo/cosec/spring/boot/starter/authorization/cache/CoSecPermissionCacheAutoConfiguration;", "", "cacheProperties", "Lme/ahoo/cosec/spring/boot/starter/authorization/cache/CacheProperties;", "(Lme/ahoo/cosec/spring/boot/starter/authorization/cache/CacheProperties;)V", "appPermissionCache", "Lme/ahoo/cosec/redis/AppPermissionCache;", "cacheSource", "Lme/ahoo/cache/CacheSource;", "", "Lme/ahoo/cosec/api/permission/AppPermission;", "redisTemplate", "Lorg/springframework/data/redis/core/StringRedisTemplate;", "cacheManager", "Lme/ahoo/cache/CacheManager;", "clientIdGenerator", "Lme/ahoo/cache/util/ClientIdGenerator;", "appPermissionCacheSource", "rolePermissionCache", "Lme/ahoo/cosec/redis/RolePermissionCache;", "", "rolePermissionCacheSource", "rolePermissionRepository", "Lme/ahoo/cosec/authorization/AppRolePermissionRepository;", "Companion", "cosec-spring-boot-starter"})
public class CoSecPermissionCacheAutoConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CacheProperties cacheProperties;
    @NotNull
    public static final String APP_PERMISSION_CACHE_BEAN_NAME = "appPermissionCache";
    @NotNull
    public static final String APP_PERMISSION_CACHE_SOURCE_BEAN_NAME = "appPermissionCacheSource";
    @NotNull
    public static final String Role_PERMISSION_CACHE_BEAN_NAME = "rolePermissionCache";
    @NotNull
    public static final String Role_PERMISSION_CACHE_SOURCE_BEAN_NAME = "rolePermissionCacheSource";

    public CoSecPermissionCacheAutoConfiguration(@NotNull CacheProperties cacheProperties) {
        Intrinsics.checkNotNullParameter((Object)cacheProperties, (String)"cacheProperties");
        this.cacheProperties = cacheProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public AppRolePermissionRepository rolePermissionRepository(@NotNull AppPermissionCache appPermissionCache, @NotNull RolePermissionCache rolePermissionCache) {
        Intrinsics.checkNotNullParameter((Object)appPermissionCache, (String)APP_PERMISSION_CACHE_BEAN_NAME);
        Intrinsics.checkNotNullParameter((Object)rolePermissionCache, (String)Role_PERMISSION_CACHE_BEAN_NAME);
        return (AppRolePermissionRepository)new RedisAppRolePermissionRepository(appPermissionCache, rolePermissionCache);
    }

    @Bean(value={"appPermissionCacheSource"})
    @ConditionalOnMissingBean(name={"appPermissionCacheSource"})
    @NotNull
    public CacheSource<String, AppPermission> appPermissionCacheSource() {
        return CacheSource.Companion.noOp();
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public AppPermissionCache appPermissionCache(@Qualifier(value="appPermissionCacheSource") @NotNull CacheSource<String, AppPermission> cacheSource, @NotNull StringRedisTemplate redisTemplate, @NotNull CacheManager cacheManager, @NotNull ClientIdGenerator clientIdGenerator) {
        Intrinsics.checkNotNullParameter(cacheSource, (String)"cacheSource");
        Intrinsics.checkNotNullParameter((Object)redisTemplate, (String)"redisTemplate");
        Intrinsics.checkNotNullParameter((Object)cacheManager, (String)"cacheManager");
        Intrinsics.checkNotNullParameter((Object)clientIdGenerator, (String)"clientIdGenerator");
        String clientId = clientIdGenerator.generate();
        String cacheKeyPrefix = this.cacheProperties.getAppPermissionKeyPrefix();
        ObjectToJsonCodecExecutor codecExecutor = new ObjectToJsonCodecExecutor(AppPermission.class, redisTemplate, (ObjectMapper)CoSecJsonSerializer.INSTANCE);
        DistributedCache distributedCaching = (DistributedCache)new RedisDistributedCache(redisTemplate, (CodecExecutor)codecExecutor);
        CoherentCache delegate = cacheManager.getOrCreateCache(new CacheConfig(APP_PERMISSION_CACHE_BEAN_NAME, clientId, (KeyConverter)new ToStringKeyConverter(cacheKeyPrefix), distributedCaching, null, cacheSource, null, 80, null));
        return new AppPermissionCache((Cache)delegate);
    }

    @Bean(value={"rolePermissionCacheSource"})
    @ConditionalOnMissingBean(name={"rolePermissionCacheSource"})
    @NotNull
    public CacheSource<String, Set<String>> rolePermissionCacheSource() {
        return CacheSource.Companion.noOp();
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public RolePermissionCache rolePermissionCache(@Qualifier(value="rolePermissionCacheSource") @NotNull CacheSource<String, Set<String>> cacheSource, @NotNull StringRedisTemplate redisTemplate, @NotNull CacheManager cacheManager, @NotNull ClientIdGenerator clientIdGenerator) {
        Intrinsics.checkNotNullParameter(cacheSource, (String)"cacheSource");
        Intrinsics.checkNotNullParameter((Object)redisTemplate, (String)"redisTemplate");
        Intrinsics.checkNotNullParameter((Object)cacheManager, (String)"cacheManager");
        Intrinsics.checkNotNullParameter((Object)clientIdGenerator, (String)"clientIdGenerator");
        String clientId = clientIdGenerator.generate();
        String cacheKeyPrefix = this.cacheProperties.getRolePermissionKeyPrefix();
        SetToSetCodecExecutor codecExecutor = new SetToSetCodecExecutor(redisTemplate);
        DistributedCache distributedCaching = (DistributedCache)new RedisDistributedCache(redisTemplate, (CodecExecutor)codecExecutor);
        CoherentCache delegate = cacheManager.getOrCreateCache(new CacheConfig(Role_PERMISSION_CACHE_BEAN_NAME, clientId, (KeyConverter)new ToStringKeyConverter(cacheKeyPrefix), distributedCaching, null, cacheSource, null, 80, null));
        return new RolePermissionCache((Cache)delegate);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lme/ahoo/cosec/spring/boot/starter/authorization/cache/CoSecPermissionCacheAutoConfiguration$Companion;", "", "()V", "APP_PERMISSION_CACHE_BEAN_NAME", "", "APP_PERMISSION_CACHE_SOURCE_BEAN_NAME", "Role_PERMISSION_CACHE_BEAN_NAME", "Role_PERMISSION_CACHE_SOURCE_BEAN_NAME", "cosec-spring-boot-starter"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

