/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosec.spring.boot.starter.authentication.oauth;

import java.lang.reflect.Constructor;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.cosec.oauth.DirectOAuthUserPrincipalConverter;
import me.ahoo.cosec.oauth.OAuthAuthentication;
import me.ahoo.cosec.oauth.OAuthProvider;
import me.ahoo.cosec.oauth.OAuthProviderManager;
import me.ahoo.cosec.oauth.OAuthUser;
import me.ahoo.cosec.oauth.OAuthUserPrincipalConverter;
import me.ahoo.cosec.oauth.justauth.JustAuthProvider;
import me.ahoo.cosec.oauth.justauth.RedisAuthStateCache;
import me.ahoo.cosec.spring.boot.starter.ConditionalOnCoSecEnabled;
import me.ahoo.cosec.spring.boot.starter.authentication.ConditionalOnAuthenticationEnabled;
import me.ahoo.cosec.spring.boot.starter.authentication.oauth.ConditionalOnOAuthAuthenticationEnabled;
import me.ahoo.cosec.spring.boot.starter.authentication.oauth.OAuthAuthenticationProperties;
import me.ahoo.cosid.IdGenerator;
import me.zhyd.oauth.cache.AuthStateCache;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.request.AuthRequest;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.core.StringRedisTemplate;

@AutoConfiguration
@ConditionalOnCoSecEnabled
@ConditionalOnAuthenticationEnabled
@ConditionalOnOAuthAuthenticationEnabled
@ConditionalOnClass(value={OAuthUser.class})
@EnableConfigurationProperties(value={OAuthAuthenticationProperties.class})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0017J\b\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0017J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lme/ahoo/cosec/spring/boot/starter/authentication/oauth/CoSecOAuthAuthenticationAutoConfiguration;", "", "oAuthAuthenticationProperties", "Lme/ahoo/cosec/spring/boot/starter/authentication/oauth/OAuthAuthenticationProperties;", "(Lme/ahoo/cosec/spring/boot/starter/authentication/oauth/OAuthAuthenticationProperties;)V", "authStateCache", "Lme/zhyd/oauth/cache/AuthStateCache;", "stringRedisTemplate", "Lorg/springframework/data/redis/core/StringRedisTemplate;", "directOAuthUserPrincipalConverter", "Lme/ahoo/cosec/oauth/OAuthUserPrincipalConverter;", "oAuthAuthentication", "Lme/ahoo/cosec/oauth/OAuthAuthentication;", "principalConverter", "oAuthProviderManager", "Lme/ahoo/cosec/oauth/OAuthProviderManager;", "idGenerator", "Lme/ahoo/cosid/IdGenerator;", "cosec-spring-boot-starter"})
public class CoSecOAuthAuthenticationAutoConfiguration {
    @NotNull
    private final OAuthAuthenticationProperties oAuthAuthenticationProperties;

    public CoSecOAuthAuthenticationAutoConfiguration(@NotNull OAuthAuthenticationProperties oAuthAuthenticationProperties) {
        Intrinsics.checkNotNullParameter((Object)oAuthAuthenticationProperties, (String)"oAuthAuthenticationProperties");
        this.oAuthAuthenticationProperties = oAuthAuthenticationProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public AuthStateCache authStateCache(@NotNull StringRedisTemplate stringRedisTemplate) {
        Intrinsics.checkNotNullParameter((Object)stringRedisTemplate, (String)"stringRedisTemplate");
        return (AuthStateCache)new RedisAuthStateCache(stringRedisTemplate, null, 2, null);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public OAuthProviderManager oAuthProviderManager(@NotNull AuthStateCache authStateCache, @NotNull IdGenerator idGenerator) {
        Intrinsics.checkNotNullParameter((Object)authStateCache, (String)"authStateCache");
        Intrinsics.checkNotNullParameter((Object)idGenerator, (String)"idGenerator");
        for (Map.Entry<String, OAuthAuthenticationProperties.Provider> entry : this.oAuthAuthenticationProperties.getRegistration().entrySet()) {
            Constructor authRequestCtor;
            Class authRequestClass;
            String key = entry.getKey();
            OAuthAuthenticationProperties.Provider provider = entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)provider.getType().getTargetClass(), (String)"provider.type.targetClass");
            Object[] objectArray = new Class[]{AuthConfig.class, AuthStateCache.class};
            Intrinsics.checkNotNullExpressionValue(authRequestClass.getConstructor((Class<?>[])objectArray), (String)"authRequestClass.getCons\u2026class.java,\n            )");
            objectArray = new Object[]{provider, authStateCache};
            AuthRequest authRequest = (AuthRequest)BeanUtils.instantiateClass(authRequestCtor, (Object[])objectArray);
            OAuthProvider authProvider = (OAuthProvider)new JustAuthProvider(key, authRequest, idGenerator);
            OAuthProviderManager.INSTANCE.register(authProvider);
        }
        return OAuthProviderManager.INSTANCE;
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public OAuthUserPrincipalConverter directOAuthUserPrincipalConverter() {
        return (OAuthUserPrincipalConverter)DirectOAuthUserPrincipalConverter.INSTANCE;
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public OAuthAuthentication oAuthAuthentication(@NotNull OAuthUserPrincipalConverter principalConverter) {
        Intrinsics.checkNotNullParameter((Object)principalConverter, (String)"principalConverter");
        return new OAuthAuthentication(principalConverter);
    }
}

