/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosec.spring.boot.starter.jwt;

import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.ConstructorBinding;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@ConstructorBinding
@ConfigurationProperties(prefix="cosec.jwt")
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010\b\n\u0002\b\u0005\b\u0087\b\u0018\u0000 $2\u00020\u0001:\u0003#$%B+\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\tH\u00c6\u0003J1\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u00032\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\t\u0010\"\u001a\u00020\u0007H\u00d6\u0001R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001e\u0010\b\u001a\u00020\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006&"}, d2={"Lme/ahoo/cosec/spring/boot/starter/jwt/JwtProperties;", "", "enabled", "", "algorithm", "Lme/ahoo/cosec/spring/boot/starter/jwt/JwtProperties$Algorithm;", "secret", "", "tokenValidity", "Lme/ahoo/cosec/spring/boot/starter/jwt/JwtProperties$TokenValidity;", "(ZLme/ahoo/cosec/spring/boot/starter/jwt/JwtProperties$Algorithm;Ljava/lang/String;Lme/ahoo/cosec/spring/boot/starter/jwt/JwtProperties$TokenValidity;)V", "getAlgorithm", "()Lme/ahoo/cosec/spring/boot/starter/jwt/JwtProperties$Algorithm;", "setAlgorithm", "(Lme/ahoo/cosec/spring/boot/starter/jwt/JwtProperties$Algorithm;)V", "getEnabled", "()Z", "getSecret", "()Ljava/lang/String;", "setSecret", "(Ljava/lang/String;)V", "getTokenValidity", "()Lme/ahoo/cosec/spring/boot/starter/jwt/JwtProperties$TokenValidity;", "setTokenValidity", "(Lme/ahoo/cosec/spring/boot/starter/jwt/JwtProperties$TokenValidity;)V", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "Algorithm", "Companion", "TokenValidity", "cosec-spring-boot-starter"})
public final class JwtProperties {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean enabled;
    @NotNull
    private Algorithm algorithm;
    @NotNull
    private String secret;
    @NestedConfigurationProperty
    @NotNull
    private TokenValidity tokenValidity;
    @NotNull
    public static final String PREFIX = "cosec.jwt";

    public JwtProperties(boolean enabled, @NotNull Algorithm algorithm, @NotNull String secret, @NotNull TokenValidity tokenValidity) {
        Intrinsics.checkNotNullParameter((Object)((Object)algorithm), (String)"algorithm");
        Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
        Intrinsics.checkNotNullParameter((Object)tokenValidity, (String)"tokenValidity");
        this.enabled = enabled;
        this.algorithm = algorithm;
        this.secret = secret;
        this.tokenValidity = tokenValidity;
    }

    public /* synthetic */ JwtProperties(boolean bl, Algorithm algorithm, String string, TokenValidity tokenValidity, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            algorithm = Algorithm.HMAC256;
        }
        if ((n & 8) != 0) {
            tokenValidity = new TokenValidity(null, null, 3, null);
        }
        this(bl, algorithm, string, tokenValidity);
    }

    public final boolean getEnabled() {
        return this.enabled;
    }

    @NotNull
    public final Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public final void setAlgorithm(@NotNull Algorithm algorithm) {
        Intrinsics.checkNotNullParameter((Object)((Object)algorithm), (String)"<set-?>");
        this.algorithm = algorithm;
    }

    @NotNull
    public final String getSecret() {
        return this.secret;
    }

    public final void setSecret(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.secret = string;
    }

    @NotNull
    public final TokenValidity getTokenValidity() {
        return this.tokenValidity;
    }

    public final void setTokenValidity(@NotNull TokenValidity tokenValidity) {
        Intrinsics.checkNotNullParameter((Object)tokenValidity, (String)"<set-?>");
        this.tokenValidity = tokenValidity;
    }

    public final boolean component1() {
        return this.enabled;
    }

    @NotNull
    public final Algorithm component2() {
        return this.algorithm;
    }

    @NotNull
    public final String component3() {
        return this.secret;
    }

    @NotNull
    public final TokenValidity component4() {
        return this.tokenValidity;
    }

    @NotNull
    public final JwtProperties copy(boolean enabled, @NotNull Algorithm algorithm, @NotNull String secret, @NotNull TokenValidity tokenValidity) {
        Intrinsics.checkNotNullParameter((Object)((Object)algorithm), (String)"algorithm");
        Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
        Intrinsics.checkNotNullParameter((Object)tokenValidity, (String)"tokenValidity");
        return new JwtProperties(enabled, algorithm, secret, tokenValidity);
    }

    public static /* synthetic */ JwtProperties copy$default(JwtProperties jwtProperties, boolean bl, Algorithm algorithm, String string, TokenValidity tokenValidity, int n, Object object) {
        if ((n & 1) != 0) {
            bl = jwtProperties.enabled;
        }
        if ((n & 2) != 0) {
            algorithm = jwtProperties.algorithm;
        }
        if ((n & 4) != 0) {
            string = jwtProperties.secret;
        }
        if ((n & 8) != 0) {
            tokenValidity = jwtProperties.tokenValidity;
        }
        return jwtProperties.copy(bl, algorithm, string, tokenValidity);
    }

    @NotNull
    public String toString() {
        return "JwtProperties(enabled=" + this.enabled + ", algorithm=" + (Object)((Object)this.algorithm) + ", secret=" + this.secret + ", tokenValidity=" + this.tokenValidity + ')';
    }

    public int hashCode() {
        int n = this.enabled ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        int result = n;
        result = result * 31 + this.algorithm.hashCode();
        result = result * 31 + this.secret.hashCode();
        result = result * 31 + this.tokenValidity.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JwtProperties)) {
            return false;
        }
        JwtProperties jwtProperties = (JwtProperties)other;
        if (this.enabled != jwtProperties.enabled) {
            return false;
        }
        if (this.algorithm != jwtProperties.algorithm) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.secret, (Object)jwtProperties.secret)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.tokenValidity, (Object)jwtProperties.tokenValidity);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lme/ahoo/cosec/spring/boot/starter/jwt/JwtProperties$Algorithm;", "", "(Ljava/lang/String;I)V", "HMAC256", "HMAC384", "HMAC512", "cosec-spring-boot-starter"})
    public static final class Algorithm
    extends Enum<Algorithm> {
        public static final /* enum */ Algorithm HMAC256 = new Algorithm();
        public static final /* enum */ Algorithm HMAC384 = new Algorithm();
        public static final /* enum */ Algorithm HMAC512 = new Algorithm();
        private static final /* synthetic */ Algorithm[] $VALUES;

        public static Algorithm[] values() {
            return (Algorithm[])$VALUES.clone();
        }

        public static Algorithm valueOf(String value) {
            return Enum.valueOf(Algorithm.class, value);
        }

        static {
            $VALUES = algorithmArray = new Algorithm[]{Algorithm.HMAC256, Algorithm.HMAC384, Algorithm.HMAC512};
        }
    }

    @ConstructorBinding
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\t\u00a8\u0006\u0016"}, d2={"Lme/ahoo/cosec/spring/boot/starter/jwt/JwtProperties$TokenValidity;", "", "access", "Ljava/time/Duration;", "refresh", "(Ljava/time/Duration;Ljava/time/Duration;)V", "getAccess", "()Ljava/time/Duration;", "setAccess", "(Ljava/time/Duration;)V", "getRefresh", "setRefresh", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "cosec-spring-boot-starter"})
    public static final class TokenValidity {
        @NotNull
        private Duration access;
        @NotNull
        private Duration refresh;

        public TokenValidity(@NotNull Duration access, @NotNull Duration refresh) {
            Intrinsics.checkNotNullParameter((Object)access, (String)"access");
            Intrinsics.checkNotNullParameter((Object)refresh, (String)"refresh");
            this.access = access;
            this.refresh = refresh;
        }

        public /* synthetic */ TokenValidity(Duration duration, Duration duration2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                Duration duration3 = Duration.ofMinutes(10L);
                Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"ofMinutes(10)");
                duration = duration3;
            }
            if ((n & 2) != 0) {
                Duration duration4 = Duration.ofDays(7L);
                Intrinsics.checkNotNullExpressionValue((Object)duration4, (String)"ofDays(7)");
                duration2 = duration4;
            }
            this(duration, duration2);
        }

        @NotNull
        public final Duration getAccess() {
            return this.access;
        }

        public final void setAccess(@NotNull Duration duration) {
            Intrinsics.checkNotNullParameter((Object)duration, (String)"<set-?>");
            this.access = duration;
        }

        @NotNull
        public final Duration getRefresh() {
            return this.refresh;
        }

        public final void setRefresh(@NotNull Duration duration) {
            Intrinsics.checkNotNullParameter((Object)duration, (String)"<set-?>");
            this.refresh = duration;
        }

        @NotNull
        public final Duration component1() {
            return this.access;
        }

        @NotNull
        public final Duration component2() {
            return this.refresh;
        }

        @NotNull
        public final TokenValidity copy(@NotNull Duration access, @NotNull Duration refresh) {
            Intrinsics.checkNotNullParameter((Object)access, (String)"access");
            Intrinsics.checkNotNullParameter((Object)refresh, (String)"refresh");
            return new TokenValidity(access, refresh);
        }

        public static /* synthetic */ TokenValidity copy$default(TokenValidity tokenValidity, Duration duration, Duration duration2, int n, Object object) {
            if ((n & 1) != 0) {
                duration = tokenValidity.access;
            }
            if ((n & 2) != 0) {
                duration2 = tokenValidity.refresh;
            }
            return tokenValidity.copy(duration, duration2);
        }

        @NotNull
        public String toString() {
            return "TokenValidity(access=" + this.access + ", refresh=" + this.refresh + ')';
        }

        public int hashCode() {
            int result = this.access.hashCode();
            result = result * 31 + this.refresh.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TokenValidity)) {
                return false;
            }
            TokenValidity tokenValidity = (TokenValidity)other;
            if (!Intrinsics.areEqual((Object)this.access, (Object)tokenValidity.access)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.refresh, (Object)tokenValidity.refresh);
        }

        public TokenValidity() {
            this(null, null, 3, null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lme/ahoo/cosec/spring/boot/starter/jwt/JwtProperties$Companion;", "", "()V", "PREFIX", "", "cosec-spring-boot-starter"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

