/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosec.spring.boot.starter.authorization;

import javax.servlet.http.HttpServletRequest;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.cosec.api.authorization.Authorization;
import me.ahoo.cosec.authorization.PermissionRepository;
import me.ahoo.cosec.authorization.SimpleAuthorization;
import me.ahoo.cosec.context.SecurityContextParser;
import me.ahoo.cosec.context.request.RemoteIpResolver;
import me.ahoo.cosec.context.request.RequestParser;
import me.ahoo.cosec.servlet.AuthorizationFilter;
import me.ahoo.cosec.servlet.ServletRequestParser;
import me.ahoo.cosec.servlet.ServletRequestSecurityContextParser;
import me.ahoo.cosec.servlet.ServletXForwardedRemoteIpResolver;
import me.ahoo.cosec.spring.boot.starter.ConditionalOnCoSecEnabled;
import me.ahoo.cosec.spring.boot.starter.authorization.AuthorizationProperties;
import me.ahoo.cosec.spring.boot.starter.authorization.ConditionalOnAuthorizationEnabled;
import me.ahoo.cosec.token.TokenVerifier;
import me.ahoo.cosec.webflux.ReactiveAuthorizationFilter;
import me.ahoo.cosec.webflux.ReactiveRequestParser;
import me.ahoo.cosec.webflux.ReactiveSecurityContextParser;
import me.ahoo.cosec.webflux.ReactiveXForwardedRemoteIpResolver;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.server.ServerWebExchange;

@AutoConfiguration
@ConditionalOnCoSecEnabled
@ConditionalOnAuthorizationEnabled
@EnableConfigurationProperties(value={AuthorizationProperties.class})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 \u00072\u00020\u0001:\u0003\u0007\b\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0017\u00a8\u0006\n"}, d2={"Lme/ahoo/cosec/spring/boot/starter/authorization/CoSecAuthorizationAutoConfiguration;", "", "()V", "cosecAuthorization", "Lme/ahoo/cosec/api/authorization/Authorization;", "permissionRepository", "Lme/ahoo/cosec/authorization/PermissionRepository;", "Companion", "WebFlux", "WebMvc", "cosec-spring-boot-starter"})
public class CoSecAuthorizationAutoConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String SERVLET_REMOTE_IP_RESOLVER_BEAN_NAME = "servletRemoteIpResolver";
    @NotNull
    public static final String SERVLET_REQUEST_PARSER_BEAN_NAME = "servletRequestParser";
    @NotNull
    public static final String SERVLET_SECURITY_CONTEXT_PARSER_BEAN_NAME = "servletSecurityContextParser";
    @NotNull
    public static final String REACTIVE_REMOTE_IP_RESOLVER_BEAN_NAME = "reactiveRemoteIpResolver";
    @NotNull
    public static final String REACTIVE_REQUEST_PARSER_BEAN_NAME = "reactiveRequestParser";
    @NotNull
    public static final String REACTIVE_SECURITY_CONTEXT_PARSER_BEAN_NAME = "reactiveSecurityContextParser";

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public Authorization cosecAuthorization(@NotNull PermissionRepository permissionRepository) {
        Intrinsics.checkNotNullParameter((Object)permissionRepository, (String)"permissionRepository");
        return (Authorization)new SimpleAuthorization(permissionRepository);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lme/ahoo/cosec/spring/boot/starter/authorization/CoSecAuthorizationAutoConfiguration$Companion;", "", "()V", "REACTIVE_REMOTE_IP_RESOLVER_BEAN_NAME", "", "REACTIVE_REQUEST_PARSER_BEAN_NAME", "REACTIVE_SECURITY_CONTEXT_PARSER_BEAN_NAME", "SERVLET_REMOTE_IP_RESOLVER_BEAN_NAME", "SERVLET_REQUEST_PARSER_BEAN_NAME", "SERVLET_SECURITY_CONTEXT_PARSER_BEAN_NAME", "cosec-spring-boot-starter"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Configuration
    @ConditionalOnClass(name={"me.ahoo.cosec.servlet.AuthorizationFilter"})
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u000e\b\u0001\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u000e\b\u0001\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bH\u0017J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\rH\u0017J\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\rH\u0017J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0017\u00a8\u0006\u0012"}, d2={"Lme/ahoo/cosec/spring/boot/starter/authorization/CoSecAuthorizationAutoConfiguration$WebMvc;", "", "()V", "authorizationFilter", "Lme/ahoo/cosec/servlet/AuthorizationFilter;", "securityContextParser", "Lme/ahoo/cosec/context/SecurityContextParser;", "Ljavax/servlet/http/HttpServletRequest;", "authorization", "Lme/ahoo/cosec/api/authorization/Authorization;", "requestParser", "Lme/ahoo/cosec/context/request/RequestParser;", "servletRemoteIpResolver", "Lme/ahoo/cosec/context/request/RemoteIpResolver;", "servletRequestParser", "servletSecurityContextParser", "tokenVerifier", "Lme/ahoo/cosec/token/TokenVerifier;", "cosec-spring-boot-starter"})
    public static class WebMvc {
        @Bean(value={"servletRemoteIpResolver"})
        @ConditionalOnMissingBean(name={"servletRemoteIpResolver"})
        @NotNull
        public RemoteIpResolver<HttpServletRequest> servletRemoteIpResolver() {
            return (RemoteIpResolver)ServletXForwardedRemoteIpResolver.Companion.getTRUST_ALL();
        }

        @Bean(value={"servletRequestParser"})
        @ConditionalOnMissingBean(name={"servletRequestParser"})
        @NotNull
        public RequestParser<HttpServletRequest> servletRequestParser(@NotNull RemoteIpResolver<HttpServletRequest> servletRemoteIpResolver) {
            Intrinsics.checkNotNullParameter(servletRemoteIpResolver, (String)CoSecAuthorizationAutoConfiguration.SERVLET_REMOTE_IP_RESOLVER_BEAN_NAME);
            return (RequestParser)new ServletRequestParser(servletRemoteIpResolver);
        }

        @Bean(value={"servletSecurityContextParser"})
        @ConditionalOnMissingBean(name={"servletSecurityContextParser"})
        @NotNull
        public SecurityContextParser<HttpServletRequest> servletSecurityContextParser(@NotNull TokenVerifier tokenVerifier) {
            Intrinsics.checkNotNullParameter((Object)tokenVerifier, (String)"tokenVerifier");
            return (SecurityContextParser)new ServletRequestSecurityContextParser(tokenVerifier);
        }

        @Bean
        @ConditionalOnMissingBean
        @NotNull
        public AuthorizationFilter authorizationFilter(@Qualifier(value="servletSecurityContextParser") @NotNull SecurityContextParser<HttpServletRequest> securityContextParser, @NotNull Authorization authorization, @Qualifier(value="servletRequestParser") @NotNull RequestParser<HttpServletRequest> requestParser) {
            Intrinsics.checkNotNullParameter(securityContextParser, (String)"securityContextParser");
            Intrinsics.checkNotNullParameter((Object)authorization, (String)"authorization");
            Intrinsics.checkNotNullParameter(requestParser, (String)"requestParser");
            return new AuthorizationFilter(securityContextParser, authorization, requestParser);
        }
    }

    @Configuration
    @ConditionalOnClass(name={"me.ahoo.cosec.webflux.ReactiveAuthorizationFilter"})
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u000e\b\u0001\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u000e\b\u0001\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010\n\u001a\u00020\u000bH\u0017J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\rH\u0017J\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\rH\u0017J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0017\u00a8\u0006\u0012"}, d2={"Lme/ahoo/cosec/spring/boot/starter/authorization/CoSecAuthorizationAutoConfiguration$WebFlux;", "", "()V", "reactiveAuthorizationFilter", "Lme/ahoo/cosec/webflux/ReactiveAuthorizationFilter;", "securityContextParser", "Lme/ahoo/cosec/context/SecurityContextParser;", "Lorg/springframework/web/server/ServerWebExchange;", "requestParser", "Lme/ahoo/cosec/context/request/RequestParser;", "authorization", "Lme/ahoo/cosec/api/authorization/Authorization;", "reactiveRemoteIpResolver", "Lme/ahoo/cosec/context/request/RemoteIpResolver;", "reactiveRequestParser", "reactiveSecurityContextParser", "tokenVerifier", "Lme/ahoo/cosec/token/TokenVerifier;", "cosec-spring-boot-starter"})
    public static class WebFlux {
        @Bean(value={"reactiveRemoteIpResolver"})
        @ConditionalOnMissingBean(name={"reactiveRemoteIpResolver"})
        @NotNull
        public RemoteIpResolver<ServerWebExchange> reactiveRemoteIpResolver() {
            return (RemoteIpResolver)ReactiveXForwardedRemoteIpResolver.Companion.getTRUST_ALL();
        }

        @Bean(value={"reactiveRequestParser"})
        @ConditionalOnMissingBean(name={"reactiveRequestParser"})
        @NotNull
        public RequestParser<ServerWebExchange> reactiveRequestParser(@NotNull RemoteIpResolver<ServerWebExchange> reactiveRemoteIpResolver) {
            Intrinsics.checkNotNullParameter(reactiveRemoteIpResolver, (String)CoSecAuthorizationAutoConfiguration.REACTIVE_REMOTE_IP_RESOLVER_BEAN_NAME);
            return (RequestParser)new ReactiveRequestParser(reactiveRemoteIpResolver);
        }

        @Bean(value={"reactiveSecurityContextParser"})
        @ConditionalOnMissingBean(name={"reactiveSecurityContextParser"})
        @NotNull
        public SecurityContextParser<ServerWebExchange> reactiveSecurityContextParser(@NotNull TokenVerifier tokenVerifier) {
            Intrinsics.checkNotNullParameter((Object)tokenVerifier, (String)"tokenVerifier");
            return (SecurityContextParser)new ReactiveSecurityContextParser(tokenVerifier);
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnMissingClass(value={"org.springframework.cloud.gateway.filter.GlobalFilter"})
        @NotNull
        public ReactiveAuthorizationFilter reactiveAuthorizationFilter(@Qualifier(value="reactiveSecurityContextParser") @NotNull SecurityContextParser<ServerWebExchange> securityContextParser, @Qualifier(value="reactiveRequestParser") @NotNull RequestParser<ServerWebExchange> requestParser, @NotNull Authorization authorization) {
            Intrinsics.checkNotNullParameter(securityContextParser, (String)"securityContextParser");
            Intrinsics.checkNotNullParameter(requestParser, (String)"requestParser");
            Intrinsics.checkNotNullParameter((Object)authorization, (String)"authorization");
            return new ReactiveAuthorizationFilter(securityContextParser, requestParser, authorization);
        }
    }
}

