/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosec.spring.boot.starter.authentication.oauth;

import java.lang.reflect.Constructor;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.cosec.oauth.OAuthUser;
import me.ahoo.cosec.oauth.client.DirectOAuthClientPrincipalConverter;
import me.ahoo.cosec.oauth.client.JustAuthClient;
import me.ahoo.cosec.oauth.client.OAuthClient;
import me.ahoo.cosec.oauth.client.OAuthClientAuthentication;
import me.ahoo.cosec.oauth.client.OAuthClientManager;
import me.ahoo.cosec.oauth.client.OAuthClientPrincipalConverter;
import me.ahoo.cosec.oauth.client.RedisAuthStateCache;
import me.ahoo.cosec.spring.boot.starter.ConditionalOnCoSecEnabled;
import me.ahoo.cosec.spring.boot.starter.authentication.ConditionalOnAuthenticationEnabled;
import me.ahoo.cosec.spring.boot.starter.authentication.oauth.ConditionalOnOAuthAuthenticationEnabled;
import me.ahoo.cosec.spring.boot.starter.authentication.oauth.OAuthClientAuthenticationProperties;
import me.ahoo.cosid.IdGenerator;
import me.zhyd.oauth.cache.AuthStateCache;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.request.AuthRequest;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.core.StringRedisTemplate;

@AutoConfiguration
@ConditionalOnCoSecEnabled
@ConditionalOnAuthenticationEnabled
@ConditionalOnOAuthAuthenticationEnabled
@ConditionalOnClass(value={OAuthUser.class})
@EnableConfigurationProperties(value={OAuthClientAuthenticationProperties.class})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\b\u0010\u000b\u001a\u00020\nH\u0017J\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lme/ahoo/cosec/spring/boot/starter/authentication/oauth/CoSecOAuthClientAuthenticationAutoConfiguration;", "", "authenticationProperties", "Lme/ahoo/cosec/spring/boot/starter/authentication/oauth/OAuthClientAuthenticationProperties;", "(Lme/ahoo/cosec/spring/boot/starter/authentication/oauth/OAuthClientAuthenticationProperties;)V", "authAuthentication", "Lme/ahoo/cosec/oauth/client/OAuthClientAuthentication;", "authProvider", "Lme/ahoo/cosec/oauth/client/OAuthClientManager;", "principalConverter", "Lme/ahoo/cosec/oauth/client/OAuthClientPrincipalConverter;", "authPrincipalConverter", "authProviderManager", "authStateCache", "Lme/zhyd/oauth/cache/AuthStateCache;", "idGenerator", "Lme/ahoo/cosid/IdGenerator;", "stringRedisTemplate", "Lorg/springframework/data/redis/core/StringRedisTemplate;", "cosec-spring-boot-starter"})
public class CoSecOAuthClientAuthenticationAutoConfiguration {
    @NotNull
    private final OAuthClientAuthenticationProperties authenticationProperties;

    public CoSecOAuthClientAuthenticationAutoConfiguration(@NotNull OAuthClientAuthenticationProperties authenticationProperties) {
        Intrinsics.checkNotNullParameter((Object)authenticationProperties, (String)"authenticationProperties");
        this.authenticationProperties = authenticationProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public AuthStateCache authStateCache(@NotNull StringRedisTemplate stringRedisTemplate) {
        Intrinsics.checkNotNullParameter((Object)stringRedisTemplate, (String)"stringRedisTemplate");
        return (AuthStateCache)new RedisAuthStateCache(stringRedisTemplate, null, 2, null);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public OAuthClientManager authProviderManager(@NotNull AuthStateCache authStateCache, @NotNull IdGenerator idGenerator) {
        Intrinsics.checkNotNullParameter((Object)authStateCache, (String)"authStateCache");
        Intrinsics.checkNotNullParameter((Object)idGenerator, (String)"idGenerator");
        for (Map.Entry<String, OAuthClientAuthenticationProperties.Client> entry : this.authenticationProperties.getRegistration().entrySet()) {
            Constructor authRequestCtor;
            Class authRequestClass;
            String key = entry.getKey();
            OAuthClientAuthenticationProperties.Client client = entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)client.getType().getTargetClass(), (String)"client.type.targetClass");
            Object[] objectArray = new Class[]{AuthConfig.class, AuthStateCache.class};
            Intrinsics.checkNotNullExpressionValue(authRequestClass.getConstructor((Class<?>[])objectArray), (String)"authRequestClass.getCons\u2026:class.java\n            )");
            objectArray = new Object[]{client, authStateCache};
            AuthRequest authRequest = (AuthRequest)BeanUtils.instantiateClass(authRequestCtor, (Object[])objectArray);
            OAuthClient authProvider = (OAuthClient)new JustAuthClient(key, authRequest, idGenerator);
            OAuthClientManager.INSTANCE.register(authProvider);
        }
        return OAuthClientManager.INSTANCE;
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public OAuthClientPrincipalConverter authPrincipalConverter() {
        return (OAuthClientPrincipalConverter)DirectOAuthClientPrincipalConverter.INSTANCE;
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public OAuthClientAuthentication authAuthentication(@NotNull OAuthClientManager authProvider, @NotNull OAuthClientPrincipalConverter principalConverter) {
        Intrinsics.checkNotNullParameter((Object)authProvider, (String)"authProvider");
        Intrinsics.checkNotNullParameter((Object)principalConverter, (String)"principalConverter");
        return new OAuthClientAuthentication(authProvider, principalConverter);
    }
}

