/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosec.spring.boot.starter.authorization.cache;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.cache.Cache;
import me.ahoo.cache.CacheConfig;
import me.ahoo.cache.CacheManager;
import me.ahoo.cache.CacheSource;
import me.ahoo.cache.CoherentCache;
import me.ahoo.cache.converter.KeyConverter;
import me.ahoo.cache.converter.ToStringKeyConverter;
import me.ahoo.cache.distributed.DistributedCache;
import me.ahoo.cache.spring.redis.RedisDistributedCache;
import me.ahoo.cache.spring.redis.codec.CodecExecutor;
import me.ahoo.cache.spring.redis.codec.ObjectToJsonCodecExecutor;
import me.ahoo.cache.spring.redis.codec.SetToSetCodecExecutor;
import me.ahoo.cosec.api.policy.Policy;
import me.ahoo.cosec.authorization.PolicyRepository;
import me.ahoo.cosec.redis.GlobalPolicyIndexCache;
import me.ahoo.cosec.redis.GlobalPolicyIndexKey;
import me.ahoo.cosec.redis.PolicyCache;
import me.ahoo.cosec.redis.RedisPolicyRepository;
import me.ahoo.cosec.redis.RolePolicyCache;
import me.ahoo.cosec.serialization.CoSecJsonSerializer;
import me.ahoo.cosec.spring.boot.starter.ConditionalOnCoSecEnabled;
import me.ahoo.cosec.spring.boot.starter.authorization.cache.CacheProperties;
import me.ahoo.cosec.spring.boot.starter.authorization.cache.ConditionalOnCacheEnabled;
import me.ahoo.cosid.IdGenerator;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.core.StringRedisTemplate;

@AutoConfiguration
@ConditionalOnCoSecEnabled
@ConditionalOnCacheEnabled
@ConditionalOnClass(name={"me.ahoo.cosec.redis.GlobalPolicyIndexCache"})
@EnableConfigurationProperties(value={CacheProperties.class})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J<\u0010\u0005\u001a\u00020\u00062\u001a\b\u0001\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J\u001a\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\bH\u0017J6\u0010\u0013\u001a\u00020\u00142\u0014\b\u0001\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00150\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J\u0014\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00150\bH\u0017J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J<\u0010\u0019\u001a\u00020\u001a2\u001a\b\u0001\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J\u001a\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\bH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lme/ahoo/cosec/spring/boot/starter/authorization/cache/CoSecCacheAutoConfiguration;", "", "cacheProperties", "Lme/ahoo/cosec/spring/boot/starter/authorization/cache/CacheProperties;", "(Lme/ahoo/cosec/spring/boot/starter/authorization/cache/CacheProperties;)V", "globalPolicyIndexCache", "Lme/ahoo/cosec/redis/GlobalPolicyIndexCache;", "cacheSource", "Lme/ahoo/cache/CacheSource;", "Lme/ahoo/cosec/redis/GlobalPolicyIndexKey;", "", "", "redisTemplate", "Lorg/springframework/data/redis/core/StringRedisTemplate;", "cacheManager", "Lme/ahoo/cache/CacheManager;", "idGenerator", "Lme/ahoo/cosid/IdGenerator;", "globalPolicyIndexCacheSource", "policyCache", "Lme/ahoo/cosec/redis/PolicyCache;", "Lme/ahoo/cosec/api/policy/Policy;", "policyCacheSource", "redisPolicyRepository", "Lme/ahoo/cosec/authorization/PolicyRepository;", "rolePolicyCache", "Lme/ahoo/cosec/redis/RolePolicyCache;", "rolePolicyCacheSource", "Companion", "cosec-spring-boot-starter"})
public class CoSecCacheAutoConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CacheProperties cacheProperties;
    @NotNull
    public static final String GLOBAL_POLICY_INDEX_CACHE_BEAN_NAME = "globalPolicyIndexCache";
    @NotNull
    public static final String GLOBAL_POLICY_INDEX_CACHE_SOURCE_BEAN_NAME = "globalPolicyIndexCacheSource";
    @NotNull
    public static final String ROLE_POLICY_CACHE_BEAN_NAME = "rolePolicyCache";
    @NotNull
    public static final String ROLE_POLICY_CACHE_SOURCE_BEAN_NAME = "rolePolicyCacheSource";
    @NotNull
    public static final String POLICY_CACHE_BEAN_NAME = "policyCache";
    @NotNull
    public static final String POLICY_CACHE_SOURCE_BEAN_NAME = "policyCacheSource";

    public CoSecCacheAutoConfiguration(@NotNull CacheProperties cacheProperties) {
        Intrinsics.checkNotNullParameter((Object)cacheProperties, (String)"cacheProperties");
        this.cacheProperties = cacheProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public PolicyRepository redisPolicyRepository(@NotNull GlobalPolicyIndexCache globalPolicyIndexCache2, @NotNull RolePolicyCache rolePolicyCache, @NotNull PolicyCache policyCache) {
        Intrinsics.checkNotNullParameter((Object)globalPolicyIndexCache2, (String)GLOBAL_POLICY_INDEX_CACHE_BEAN_NAME);
        Intrinsics.checkNotNullParameter((Object)rolePolicyCache, (String)ROLE_POLICY_CACHE_BEAN_NAME);
        Intrinsics.checkNotNullParameter((Object)policyCache, (String)POLICY_CACHE_BEAN_NAME);
        return (PolicyRepository)new RedisPolicyRepository(globalPolicyIndexCache2, rolePolicyCache, policyCache);
    }

    @Bean(value={"globalPolicyIndexCacheSource"})
    @ConditionalOnMissingBean(name={"globalPolicyIndexCacheSource"})
    @NotNull
    public CacheSource<GlobalPolicyIndexKey, Set<String>> globalPolicyIndexCacheSource() {
        return CacheSource.Companion.noOp();
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public GlobalPolicyIndexCache globalPolicyIndexCache(@Qualifier(value="globalPolicyIndexCacheSource") @NotNull CacheSource<GlobalPolicyIndexKey, Set<String>> cacheSource, @NotNull StringRedisTemplate redisTemplate, @NotNull CacheManager cacheManager, @NotNull IdGenerator idGenerator) {
        Intrinsics.checkNotNullParameter(cacheSource, (String)"cacheSource");
        Intrinsics.checkNotNullParameter((Object)redisTemplate, (String)"redisTemplate");
        Intrinsics.checkNotNullParameter((Object)cacheManager, (String)"cacheManager");
        Intrinsics.checkNotNullParameter((Object)idGenerator, (String)"idGenerator");
        String string = idGenerator.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"idGenerator.generateAsString()");
        String clientId = string;
        String cacheKeyPrefix = this.cacheProperties.getCacheKeyPrefix().getGlobalPolicyIndex();
        SetToSetCodecExecutor codecExecutor = new SetToSetCodecExecutor(redisTemplate);
        DistributedCache distributedCaching = (DistributedCache)new RedisDistributedCache(redisTemplate, (CodecExecutor)codecExecutor);
        CoherentCache delegate2 = cacheManager.getOrCreateCache(new CacheConfig(GLOBAL_POLICY_INDEX_CACHE_BEAN_NAME, clientId, (KeyConverter)new KeyConverter<GlobalPolicyIndexKey>(cacheKeyPrefix){
            final /* synthetic */ String $cacheKeyPrefix;
            {
                this.$cacheKeyPrefix = $cacheKeyPrefix;
            }

            @NotNull
            public String asKey(@NotNull GlobalPolicyIndexKey sourceKey) {
                Intrinsics.checkNotNullParameter((Object)sourceKey, (String)"sourceKey");
                return this.$cacheKeyPrefix;
            }
        }, distributedCaching, null, cacheSource, null, 80, null));
        return new GlobalPolicyIndexCache((Cache)delegate2);
    }

    @Bean(value={"rolePolicyCacheSource"})
    @ConditionalOnMissingBean(name={"rolePolicyCacheSource"})
    @NotNull
    public CacheSource<String, Set<String>> rolePolicyCacheSource() {
        return CacheSource.Companion.noOp();
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public RolePolicyCache rolePolicyCache(@Qualifier(value="rolePolicyCacheSource") @NotNull CacheSource<String, Set<String>> cacheSource, @NotNull StringRedisTemplate redisTemplate, @NotNull CacheManager cacheManager, @NotNull IdGenerator idGenerator) {
        Intrinsics.checkNotNullParameter(cacheSource, (String)"cacheSource");
        Intrinsics.checkNotNullParameter((Object)redisTemplate, (String)"redisTemplate");
        Intrinsics.checkNotNullParameter((Object)cacheManager, (String)"cacheManager");
        Intrinsics.checkNotNullParameter((Object)idGenerator, (String)"idGenerator");
        String string = idGenerator.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"idGenerator.generateAsString()");
        String clientId = string;
        String cacheKeyPrefix = this.cacheProperties.getCacheKeyPrefix().getRolePolicy();
        SetToSetCodecExecutor codecExecutor = new SetToSetCodecExecutor(redisTemplate);
        DistributedCache distributedCaching = (DistributedCache)new RedisDistributedCache(redisTemplate, (CodecExecutor)codecExecutor);
        CoherentCache delegate2 = cacheManager.getOrCreateCache(new CacheConfig(ROLE_POLICY_CACHE_BEAN_NAME, clientId, (KeyConverter)new ToStringKeyConverter(cacheKeyPrefix), distributedCaching, null, cacheSource, null, 80, null));
        return new RolePolicyCache((Cache)delegate2);
    }

    @Bean(value={"policyCacheSource"})
    @ConditionalOnMissingBean(name={"policyCacheSource"})
    @NotNull
    public CacheSource<String, Policy> policyCacheSource() {
        return CacheSource.Companion.noOp();
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public PolicyCache policyCache(@Qualifier(value="policyCacheSource") @NotNull CacheSource<String, Policy> cacheSource, @NotNull StringRedisTemplate redisTemplate, @NotNull CacheManager cacheManager, @NotNull IdGenerator idGenerator) {
        Intrinsics.checkNotNullParameter(cacheSource, (String)"cacheSource");
        Intrinsics.checkNotNullParameter((Object)redisTemplate, (String)"redisTemplate");
        Intrinsics.checkNotNullParameter((Object)cacheManager, (String)"cacheManager");
        Intrinsics.checkNotNullParameter((Object)idGenerator, (String)"idGenerator");
        String string = idGenerator.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"idGenerator.generateAsString()");
        String clientId = string;
        String cacheKeyPrefix = this.cacheProperties.getCacheKeyPrefix().getPolicy();
        ObjectToJsonCodecExecutor codecExecutor = new ObjectToJsonCodecExecutor(Policy.class, redisTemplate, (ObjectMapper)CoSecJsonSerializer.INSTANCE);
        DistributedCache distributedCaching = (DistributedCache)new RedisDistributedCache(redisTemplate, (CodecExecutor)codecExecutor);
        CoherentCache delegate2 = cacheManager.getOrCreateCache(new CacheConfig(POLICY_CACHE_BEAN_NAME, clientId, (KeyConverter)new ToStringKeyConverter(cacheKeyPrefix), distributedCaching, null, cacheSource, null, 80, null));
        return new PolicyCache((Cache)delegate2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lme/ahoo/cosec/spring/boot/starter/authorization/cache/CoSecCacheAutoConfiguration$Companion;", "", "()V", "GLOBAL_POLICY_INDEX_CACHE_BEAN_NAME", "", "GLOBAL_POLICY_INDEX_CACHE_SOURCE_BEAN_NAME", "POLICY_CACHE_BEAN_NAME", "POLICY_CACHE_SOURCE_BEAN_NAME", "ROLE_POLICY_CACHE_BEAN_NAME", "ROLE_POLICY_CACHE_SOURCE_BEAN_NAME", "cosec-spring-boot-starter"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

