/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosec.spring.boot.starter.authorization;

import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.boot.context.properties.ConstructorBinding;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@ConstructorBinding
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0087\b\u0018\u00002\u00020\u0001:\u0002\u001f B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0005H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0006\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006!"}, d2={"Lme/ahoo/cosec/spring/boot/starter/authorization/JwtProperties;", "", "algorithm", "Lme/ahoo/cosec/spring/boot/starter/authorization/JwtProperties$Algorithm;", "secret", "", "tokenValidity", "Lme/ahoo/cosec/spring/boot/starter/authorization/JwtProperties$TokenValidity;", "(Lme/ahoo/cosec/spring/boot/starter/authorization/JwtProperties$Algorithm;Ljava/lang/String;Lme/ahoo/cosec/spring/boot/starter/authorization/JwtProperties$TokenValidity;)V", "getAlgorithm", "()Lme/ahoo/cosec/spring/boot/starter/authorization/JwtProperties$Algorithm;", "setAlgorithm", "(Lme/ahoo/cosec/spring/boot/starter/authorization/JwtProperties$Algorithm;)V", "getSecret", "()Ljava/lang/String;", "setSecret", "(Ljava/lang/String;)V", "getTokenValidity", "()Lme/ahoo/cosec/spring/boot/starter/authorization/JwtProperties$TokenValidity;", "setTokenValidity", "(Lme/ahoo/cosec/spring/boot/starter/authorization/JwtProperties$TokenValidity;)V", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "Algorithm", "TokenValidity", "cosec-spring-boot-starter"})
public final class JwtProperties {
    @NotNull
    private Algorithm algorithm;
    @NotNull
    private String secret;
    @NestedConfigurationProperty
    @NotNull
    private TokenValidity tokenValidity;

    public JwtProperties(@NotNull Algorithm algorithm, @NotNull String secret, @NotNull TokenValidity tokenValidity) {
        Intrinsics.checkNotNullParameter((Object)((Object)algorithm), (String)"algorithm");
        Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
        Intrinsics.checkNotNullParameter((Object)tokenValidity, (String)"tokenValidity");
        this.algorithm = algorithm;
        this.secret = secret;
        this.tokenValidity = tokenValidity;
    }

    public /* synthetic */ JwtProperties(Algorithm algorithm, String string, TokenValidity tokenValidity, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            algorithm = Algorithm.HMAC256;
        }
        if ((n & 2) != 0) {
            string = "";
        }
        if ((n & 4) != 0) {
            tokenValidity = new TokenValidity(null, null, 3, null);
        }
        this(algorithm, string, tokenValidity);
    }

    @NotNull
    public final Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public final void setAlgorithm(@NotNull Algorithm algorithm) {
        Intrinsics.checkNotNullParameter((Object)((Object)algorithm), (String)"<set-?>");
        this.algorithm = algorithm;
    }

    @NotNull
    public final String getSecret() {
        return this.secret;
    }

    public final void setSecret(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.secret = string;
    }

    @NotNull
    public final TokenValidity getTokenValidity() {
        return this.tokenValidity;
    }

    public final void setTokenValidity(@NotNull TokenValidity tokenValidity) {
        Intrinsics.checkNotNullParameter((Object)tokenValidity, (String)"<set-?>");
        this.tokenValidity = tokenValidity;
    }

    @NotNull
    public final Algorithm component1() {
        return this.algorithm;
    }

    @NotNull
    public final String component2() {
        return this.secret;
    }

    @NotNull
    public final TokenValidity component3() {
        return this.tokenValidity;
    }

    @NotNull
    public final JwtProperties copy(@NotNull Algorithm algorithm, @NotNull String secret, @NotNull TokenValidity tokenValidity) {
        Intrinsics.checkNotNullParameter((Object)((Object)algorithm), (String)"algorithm");
        Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
        Intrinsics.checkNotNullParameter((Object)tokenValidity, (String)"tokenValidity");
        return new JwtProperties(algorithm, secret, tokenValidity);
    }

    public static /* synthetic */ JwtProperties copy$default(JwtProperties jwtProperties, Algorithm algorithm, String string, TokenValidity tokenValidity, int n, Object object) {
        if ((n & 1) != 0) {
            algorithm = jwtProperties.algorithm;
        }
        if ((n & 2) != 0) {
            string = jwtProperties.secret;
        }
        if ((n & 4) != 0) {
            tokenValidity = jwtProperties.tokenValidity;
        }
        return jwtProperties.copy(algorithm, string, tokenValidity);
    }

    @NotNull
    public String toString() {
        return "JwtProperties(algorithm=" + (Object)((Object)this.algorithm) + ", secret=" + this.secret + ", tokenValidity=" + this.tokenValidity + ')';
    }

    public int hashCode() {
        int result = this.algorithm.hashCode();
        result = result * 31 + this.secret.hashCode();
        result = result * 31 + this.tokenValidity.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JwtProperties)) {
            return false;
        }
        JwtProperties jwtProperties = (JwtProperties)other;
        if (this.algorithm != jwtProperties.algorithm) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.secret, (Object)jwtProperties.secret)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.tokenValidity, (Object)jwtProperties.tokenValidity);
    }

    public JwtProperties() {
        this(null, null, null, 7, null);
    }

    @ConstructorBinding
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\t\u00a8\u0006\u0016"}, d2={"Lme/ahoo/cosec/spring/boot/starter/authorization/JwtProperties$TokenValidity;", "", "access", "Ljava/time/Duration;", "refresh", "(Ljava/time/Duration;Ljava/time/Duration;)V", "getAccess", "()Ljava/time/Duration;", "setAccess", "(Ljava/time/Duration;)V", "getRefresh", "setRefresh", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "cosec-spring-boot-starter"})
    public static final class TokenValidity {
        @NotNull
        private Duration access;
        @NotNull
        private Duration refresh;

        public TokenValidity(@NotNull Duration access, @NotNull Duration refresh) {
            Intrinsics.checkNotNullParameter((Object)access, (String)"access");
            Intrinsics.checkNotNullParameter((Object)refresh, (String)"refresh");
            this.access = access;
            this.refresh = refresh;
        }

        public /* synthetic */ TokenValidity(Duration duration, Duration duration2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                Duration duration3 = Duration.ofMinutes(10L);
                Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"ofMinutes(10)");
                duration = duration3;
            }
            if ((n & 2) != 0) {
                Duration duration4 = Duration.ofDays(7L);
                Intrinsics.checkNotNullExpressionValue((Object)duration4, (String)"ofDays(7)");
                duration2 = duration4;
            }
            this(duration, duration2);
        }

        @NotNull
        public final Duration getAccess() {
            return this.access;
        }

        public final void setAccess(@NotNull Duration duration) {
            Intrinsics.checkNotNullParameter((Object)duration, (String)"<set-?>");
            this.access = duration;
        }

        @NotNull
        public final Duration getRefresh() {
            return this.refresh;
        }

        public final void setRefresh(@NotNull Duration duration) {
            Intrinsics.checkNotNullParameter((Object)duration, (String)"<set-?>");
            this.refresh = duration;
        }

        @NotNull
        public final Duration component1() {
            return this.access;
        }

        @NotNull
        public final Duration component2() {
            return this.refresh;
        }

        @NotNull
        public final TokenValidity copy(@NotNull Duration access, @NotNull Duration refresh) {
            Intrinsics.checkNotNullParameter((Object)access, (String)"access");
            Intrinsics.checkNotNullParameter((Object)refresh, (String)"refresh");
            return new TokenValidity(access, refresh);
        }

        public static /* synthetic */ TokenValidity copy$default(TokenValidity tokenValidity, Duration duration, Duration duration2, int n, Object object) {
            if ((n & 1) != 0) {
                duration = tokenValidity.access;
            }
            if ((n & 2) != 0) {
                duration2 = tokenValidity.refresh;
            }
            return tokenValidity.copy(duration, duration2);
        }

        @NotNull
        public String toString() {
            return "TokenValidity(access=" + this.access + ", refresh=" + this.refresh + ')';
        }

        public int hashCode() {
            int result = this.access.hashCode();
            result = result * 31 + this.refresh.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TokenValidity)) {
                return false;
            }
            TokenValidity tokenValidity = (TokenValidity)other;
            if (!Intrinsics.areEqual((Object)this.access, (Object)tokenValidity.access)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.refresh, (Object)tokenValidity.refresh);
        }

        public TokenValidity() {
            this(null, null, 3, null);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lme/ahoo/cosec/spring/boot/starter/authorization/JwtProperties$Algorithm;", "", "(Ljava/lang/String;I)V", "HMAC256", "HMAC384", "HMAC512", "cosec-spring-boot-starter"})
    public static final class Algorithm
    extends Enum<Algorithm> {
        public static final /* enum */ Algorithm HMAC256 = new Algorithm();
        public static final /* enum */ Algorithm HMAC384 = new Algorithm();
        public static final /* enum */ Algorithm HMAC512 = new Algorithm();
        private static final /* synthetic */ Algorithm[] $VALUES;

        public static Algorithm[] values() {
            return (Algorithm[])$VALUES.clone();
        }

        public static Algorithm valueOf(String value) {
            return Enum.valueOf(Algorithm.class, value);
        }

        static {
            $VALUES = algorithmArray = new Algorithm[]{Algorithm.HMAC256, Algorithm.HMAC384, Algorithm.HMAC512};
        }
    }
}

