/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosec.spring.boot.starter.authorization;

import com.auth0.jwt.algorithms.Algorithm;
import javax.servlet.http.HttpServletRequest;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.cosec.authorization.Authorization;
import me.ahoo.cosec.authorization.PermissionRepository;
import me.ahoo.cosec.authorization.SimpleAuthorization;
import me.ahoo.cosec.context.SecurityContextParser;
import me.ahoo.cosec.context.request.RequestParser;
import me.ahoo.cosec.context.request.RequestTenantIdParser;
import me.ahoo.cosec.jwt.JwtTokenConverter;
import me.ahoo.cosec.servlet.AuthorizationFilter;
import me.ahoo.cosec.servlet.ServletRequestParser;
import me.ahoo.cosec.servlet.ServletRequestSecurityContextParser;
import me.ahoo.cosec.servlet.ServletRequestTenantIdParser;
import me.ahoo.cosec.spring.boot.starter.ConditionalOnCoSecEnabled;
import me.ahoo.cosec.spring.boot.starter.authorization.AuthorizationProperties;
import me.ahoo.cosec.spring.boot.starter.authorization.ConditionalOnAuthorizationEnabled;
import me.ahoo.cosec.spring.boot.starter.authorization.JwtProperties;
import me.ahoo.cosec.token.TokenConverter;
import me.ahoo.cosec.webflux.ReactiveAuthorizationFilter;
import me.ahoo.cosec.webflux.ReactiveRequestParser;
import me.ahoo.cosec.webflux.ReactiveRequestTenantIdParser;
import me.ahoo.cosec.webflux.ReactiveSecurityContextParser;
import me.ahoo.cosid.IdGenerator;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.server.ServerWebExchange;

@AutoConfiguration
@ConditionalOnCoSecEnabled
@ConditionalOnAuthorizationEnabled
@EnableConfigurationProperties(value={AuthorizationProperties.class})
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u0000 \u00102\u00020\u0001:\u0003\u0010\u0011\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0017J\b\u0010\t\u001a\u00020\nH\u0017J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lme/ahoo/cosec/spring/boot/starter/authorization/CoSecAuthorizationAutoConfiguration;", "", "authorizationProperties", "Lme/ahoo/cosec/spring/boot/starter/authorization/AuthorizationProperties;", "(Lme/ahoo/cosec/spring/boot/starter/authorization/AuthorizationProperties;)V", "cosecAuthorization", "Lme/ahoo/cosec/authorization/Authorization;", "permissionRepository", "Lme/ahoo/cosec/authorization/PermissionRepository;", "cosecTokenAlgorithm", "Lcom/auth0/jwt/algorithms/Algorithm;", "cosecTokenConverter", "Lme/ahoo/cosec/token/TokenConverter;", "idGenerator", "Lme/ahoo/cosid/IdGenerator;", "algorithm", "Companion", "WebFlux", "WebMvc", "cosec-spring-boot-starter"})
public class CoSecAuthorizationAutoConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AuthorizationProperties authorizationProperties;
    @NotNull
    public static final String SERVLET_REQUEST_TENANT_ID_PARSER_BEAN_NAME = "servletRequestTenantIdParser";
    @NotNull
    public static final String SERVLET_REQUEST_PARSER_BEAN_NAME = "servletRequestParser";
    @NotNull
    public static final String SERVLET_SECURITY_CONTEXT_PARSER_BEAN_NAME = "servletSecurityContextParser";
    @NotNull
    public static final String REACTIVE_REQUEST_TENANT_ID_PARSER_BEAN_NAME = "reactiveRequestTenantIdParser";
    @NotNull
    public static final String REACTIVE_REQUEST_PARSER_BEAN_NAME = "reactiveRequestParser";
    @NotNull
    public static final String REACTIVE_SECURITY_CONTEXT_PARSER_BEAN_NAME = "reactiveSecurityContextParser";

    public CoSecAuthorizationAutoConfiguration(@NotNull AuthorizationProperties authorizationProperties) {
        Intrinsics.checkNotNullParameter((Object)authorizationProperties, (String)"authorizationProperties");
        this.authorizationProperties = authorizationProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public Algorithm cosecTokenAlgorithm() {
        Algorithm algorithm;
        JwtProperties jwtProperties = this.authorizationProperties.getJwt();
        switch (WhenMappings.$EnumSwitchMapping$0[jwtProperties.getAlgorithm().ordinal()]) {
            case 1: {
                Algorithm algorithm2 = Algorithm.HMAC256((String)jwtProperties.getSecret());
                algorithm = algorithm2;
                Intrinsics.checkNotNullExpressionValue((Object)algorithm2, (String)"HMAC256(\n               \u2026ties.secret\n            )");
                break;
            }
            case 2: {
                Algorithm algorithm3 = Algorithm.HMAC384((String)jwtProperties.getSecret());
                algorithm = algorithm3;
                Intrinsics.checkNotNullExpressionValue((Object)algorithm3, (String)"HMAC384(\n               \u2026ties.secret\n            )");
                break;
            }
            case 3: {
                Algorithm algorithm4 = Algorithm.HMAC512((String)jwtProperties.getSecret());
                algorithm = algorithm4;
                Intrinsics.checkNotNullExpressionValue((Object)algorithm4, (String)"HMAC512(\n               \u2026ties.secret\n            )");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return algorithm;
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public TokenConverter cosecTokenConverter(@NotNull IdGenerator idGenerator, @NotNull Algorithm algorithm) {
        Intrinsics.checkNotNullParameter((Object)idGenerator, (String)"idGenerator");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        JwtProperties jwtProperties = this.authorizationProperties.getJwt();
        return (TokenConverter)new JwtTokenConverter(idGenerator, algorithm, jwtProperties.getTokenValidity().getAccess(), jwtProperties.getTokenValidity().getRefresh());
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public Authorization cosecAuthorization(@NotNull PermissionRepository permissionRepository) {
        Intrinsics.checkNotNullParameter((Object)permissionRepository, (String)"permissionRepository");
        return (Authorization)new SimpleAuthorization(permissionRepository);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lme/ahoo/cosec/spring/boot/starter/authorization/CoSecAuthorizationAutoConfiguration$Companion;", "", "()V", "REACTIVE_REQUEST_PARSER_BEAN_NAME", "", "REACTIVE_REQUEST_TENANT_ID_PARSER_BEAN_NAME", "REACTIVE_SECURITY_CONTEXT_PARSER_BEAN_NAME", "SERVLET_REQUEST_PARSER_BEAN_NAME", "SERVLET_REQUEST_TENANT_ID_PARSER_BEAN_NAME", "SERVLET_SECURITY_CONTEXT_PARSER_BEAN_NAME", "cosec-spring-boot-starter"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Configuration
    @ConditionalOnClass(name={"me.ahoo.cosec.servlet.AuthorizationFilter"})
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u000e\b\u0001\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u000e\b\u0001\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bH\u0017J\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000eH\u0017J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u000eH\u0017J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0017\u00a8\u0006\u0013"}, d2={"Lme/ahoo/cosec/spring/boot/starter/authorization/CoSecAuthorizationAutoConfiguration$WebMvc;", "", "()V", "authorizationFilter", "Lme/ahoo/cosec/servlet/AuthorizationFilter;", "securityContextParser", "Lme/ahoo/cosec/context/SecurityContextParser;", "Ljavax/servlet/http/HttpServletRequest;", "authorization", "Lme/ahoo/cosec/authorization/Authorization;", "requestParser", "Lme/ahoo/cosec/context/request/RequestParser;", "servletRequestParser", "requestTenantIdParser", "Lme/ahoo/cosec/context/request/RequestTenantIdParser;", "servletRequestTenantIdParser", "servletSecurityContextParser", "tokenConverter", "Lme/ahoo/cosec/token/TokenConverter;", "cosec-spring-boot-starter"})
    public static class WebMvc {
        @Bean(value={"servletRequestTenantIdParser"})
        @ConditionalOnMissingBean(name={"servletRequestTenantIdParser"})
        @NotNull
        public RequestTenantIdParser<HttpServletRequest> servletRequestTenantIdParser() {
            return (RequestTenantIdParser)ServletRequestTenantIdParser.INSTANCE;
        }

        @Bean(value={"servletRequestParser"})
        @ConditionalOnMissingBean(name={"servletRequestParser"})
        @NotNull
        public RequestParser<HttpServletRequest> servletRequestParser(@NotNull RequestTenantIdParser<HttpServletRequest> requestTenantIdParser) {
            Intrinsics.checkNotNullParameter(requestTenantIdParser, (String)"requestTenantIdParser");
            return (RequestParser)new ServletRequestParser(requestTenantIdParser);
        }

        @Bean(value={"servletSecurityContextParser"})
        @ConditionalOnMissingBean(name={"servletSecurityContextParser"})
        @NotNull
        public SecurityContextParser<HttpServletRequest> servletSecurityContextParser(@NotNull TokenConverter tokenConverter) {
            Intrinsics.checkNotNullParameter((Object)tokenConverter, (String)"tokenConverter");
            return (SecurityContextParser)new ServletRequestSecurityContextParser(tokenConverter);
        }

        @Bean
        @ConditionalOnMissingBean
        @NotNull
        public AuthorizationFilter authorizationFilter(@Qualifier(value="servletSecurityContextParser") @NotNull SecurityContextParser<HttpServletRequest> securityContextParser, @NotNull Authorization authorization, @Qualifier(value="servletRequestParser") @NotNull RequestParser<HttpServletRequest> requestParser) {
            Intrinsics.checkNotNullParameter(securityContextParser, (String)"securityContextParser");
            Intrinsics.checkNotNullParameter((Object)authorization, (String)"authorization");
            Intrinsics.checkNotNullParameter(requestParser, (String)"requestParser");
            return new AuthorizationFilter(securityContextParser, authorization, requestParser);
        }
    }

    @Configuration
    @ConditionalOnClass(name={"me.ahoo.cosec.webflux.ReactiveAuthorizationFilter"})
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u000e\b\u0001\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u000e\b\u0001\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010\n\u001a\u00020\u000bH\u0017J\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000eH\u0017J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000eH\u0017J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0017\u00a8\u0006\u0012"}, d2={"Lme/ahoo/cosec/spring/boot/starter/authorization/CoSecAuthorizationAutoConfiguration$WebFlux;", "", "()V", "reactiveAuthorizationFilter", "Lme/ahoo/cosec/webflux/ReactiveAuthorizationFilter;", "securityContextParser", "Lme/ahoo/cosec/context/SecurityContextParser;", "Lorg/springframework/web/server/ServerWebExchange;", "requestParser", "Lme/ahoo/cosec/context/request/RequestParser;", "authorization", "Lme/ahoo/cosec/authorization/Authorization;", "reactiveRequestParser", "reactiveRequestTenantIdParser", "Lme/ahoo/cosec/context/request/RequestTenantIdParser;", "reactiveSecurityContextParser", "tokenConverter", "Lme/ahoo/cosec/token/TokenConverter;", "cosec-spring-boot-starter"})
    public static class WebFlux {
        @Bean(value={"reactiveRequestTenantIdParser"})
        @ConditionalOnMissingBean(name={"reactiveRequestTenantIdParser"})
        @NotNull
        public RequestTenantIdParser<ServerWebExchange> reactiveRequestTenantIdParser() {
            return (RequestTenantIdParser)ReactiveRequestTenantIdParser.INSTANCE;
        }

        @Bean(value={"reactiveRequestParser"})
        @ConditionalOnMissingBean(name={"reactiveRequestParser"})
        @NotNull
        public RequestParser<ServerWebExchange> reactiveRequestParser(@NotNull RequestTenantIdParser<ServerWebExchange> reactiveRequestTenantIdParser) {
            Intrinsics.checkNotNullParameter(reactiveRequestTenantIdParser, (String)CoSecAuthorizationAutoConfiguration.REACTIVE_REQUEST_TENANT_ID_PARSER_BEAN_NAME);
            return (RequestParser)new ReactiveRequestParser(reactiveRequestTenantIdParser);
        }

        @Bean(value={"reactiveSecurityContextParser"})
        @ConditionalOnMissingBean(name={"reactiveSecurityContextParser"})
        @NotNull
        public SecurityContextParser<ServerWebExchange> reactiveSecurityContextParser(@NotNull TokenConverter tokenConverter) {
            Intrinsics.checkNotNullParameter((Object)tokenConverter, (String)"tokenConverter");
            return (SecurityContextParser)new ReactiveSecurityContextParser(tokenConverter);
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnMissingClass(value={"org.springframework.cloud.gateway.filter.GlobalFilter"})
        @NotNull
        public ReactiveAuthorizationFilter reactiveAuthorizationFilter(@Qualifier(value="reactiveSecurityContextParser") @NotNull SecurityContextParser<ServerWebExchange> securityContextParser, @Qualifier(value="reactiveRequestParser") @NotNull RequestParser<ServerWebExchange> requestParser, @NotNull Authorization authorization) {
            Intrinsics.checkNotNullParameter(securityContextParser, (String)"securityContextParser");
            Intrinsics.checkNotNullParameter(requestParser, (String)"requestParser");
            Intrinsics.checkNotNullParameter((Object)authorization, (String)"authorization");
            return new ReactiveAuthorizationFilter(securityContextParser, requestParser, authorization);
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JwtProperties.Algorithm.values().length];
            try {
                nArray[JwtProperties.Algorithm.HMAC256.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JwtProperties.Algorithm.HMAC384.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JwtProperties.Algorithm.HMAC512.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

