/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosec.oauth;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.cosec.oauth.OAuthProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\u0005H\u0086\u0002J\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0005J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0006J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lme/ahoo/cosec/oauth/OAuthProviderManager;", "", "()V", "providers", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lme/ahoo/cosec/oauth/OAuthProvider;", "get", "provider", "getRequired", "register", "", "authProvider", "cosec-oauth"})
public final class OAuthProviderManager {
    @NotNull
    public static final OAuthProviderManager INSTANCE = new OAuthProviderManager();
    @NotNull
    private static final ConcurrentHashMap<String, OAuthProvider> providers = new ConcurrentHashMap();

    private OAuthProviderManager() {
    }

    @Nullable
    public final OAuthProvider get(@NotNull String provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        return providers.get(provider);
    }

    @NotNull
    public final OAuthProvider getRequired(@NotNull String provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        OAuthProvider oAuthProvider = this.get(provider);
        if (oAuthProvider == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        return oAuthProvider;
    }

    public final void register(@NotNull String provider, @NotNull OAuthProvider authProvider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)authProvider, (String)"authProvider");
        ((Map)providers).put(provider, authProvider);
    }

    public final void register(@NotNull OAuthProvider authProvider) {
        Intrinsics.checkNotNullParameter((Object)authProvider, (String)"authProvider");
        ((Map)providers).put(authProvider.getName(), authProvider);
    }
}

