/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosec.oauth;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.cosec.api.authentication.Authentication;
import me.ahoo.cosec.api.principal.CoSecPrincipal;
import me.ahoo.cosec.oauth.DirectOAuthUserPrincipalConverter;
import me.ahoo.cosec.oauth.OAuthCredentials;
import me.ahoo.cosec.oauth.OAuthProviderManager;
import me.ahoo.cosec.oauth.OAuthUser;
import me.ahoo.cosec.oauth.OAuthUserPrincipalConverter;
import org.jetbrains.annotations.NotNull;
import reactor.core.publisher.Mono;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lme/ahoo/cosec/oauth/OAuthAuthentication;", "Lme/ahoo/cosec/api/authentication/Authentication;", "Lme/ahoo/cosec/oauth/OAuthCredentials;", "Lme/ahoo/cosec/api/principal/CoSecPrincipal;", "principalConverter", "Lme/ahoo/cosec/oauth/OAuthUserPrincipalConverter;", "(Lme/ahoo/cosec/oauth/OAuthUserPrincipalConverter;)V", "supportCredentials", "Ljava/lang/Class;", "getSupportCredentials", "()Ljava/lang/Class;", "authenticate", "Lreactor/core/publisher/Mono;", "credentials", "authorizeUrl", "", "provider", "cosec-oauth"})
public final class OAuthAuthentication
implements Authentication<OAuthCredentials, CoSecPrincipal> {
    @NotNull
    private final OAuthUserPrincipalConverter principalConverter;

    public OAuthAuthentication(@NotNull OAuthUserPrincipalConverter principalConverter) {
        Intrinsics.checkNotNullParameter((Object)principalConverter, (String)"principalConverter");
        this.principalConverter = principalConverter;
    }

    public /* synthetic */ OAuthAuthentication(OAuthUserPrincipalConverter oAuthUserPrincipalConverter, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            oAuthUserPrincipalConverter = DirectOAuthUserPrincipalConverter.INSTANCE;
        }
        this(oAuthUserPrincipalConverter);
    }

    @NotNull
    public Class<OAuthCredentials> getSupportCredentials() {
        return OAuthCredentials.class;
    }

    @NotNull
    public final String authorizeUrl(@NotNull String provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        return OAuthProviderManager.INSTANCE.getRequired(provider).authorizeUrl();
    }

    @NotNull
    public Mono<CoSecPrincipal> authenticate(@NotNull OAuthCredentials credentials) {
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        Mono mono = OAuthProviderManager.INSTANCE.getRequired(credentials.getProvider()).authenticate(credentials).flatMap(arg_0 -> OAuthAuthentication.authenticate$lambda$0((Function1)new Function1<OAuthUser, Mono<? extends CoSecPrincipal>>(this, credentials){
            final /* synthetic */ OAuthAuthentication this$0;
            final /* synthetic */ OAuthCredentials $credentials;
            {
                this.this$0 = $receiver;
                this.$credentials = $credentials;
                super(1);
            }

            public final Mono<? extends CoSecPrincipal> invoke(OAuthUser it) {
                OAuthUserPrincipalConverter oAuthUserPrincipalConverter = OAuthAuthentication.access$getPrincipalConverter$p(this.this$0);
                String string = this.$credentials.getProvider();
                Intrinsics.checkNotNull((Object)it);
                return oAuthUserPrincipalConverter.convert(string, it);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"flatMap(...)");
        return mono;
    }

    private static final Mono authenticate$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Mono)$tmp0.invoke(p0);
    }

    public OAuthAuthentication() {
        this(null, 1, null);
    }

    public static final /* synthetic */ OAuthUserPrincipalConverter access$getPrincipalConverter$p(OAuthAuthentication $this) {
        return $this.principalConverter;
    }
}

