/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosec.oauth.justauth;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.zhyd.oauth.cache.AuthStateCache;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.redis.core.StringRedisTemplate;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u0005H\u0016J\u0011\u0010\u000f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0096\u0002J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lme/ahoo/cosec/oauth/justauth/RedisAuthStateCache;", "Lme/zhyd/oauth/cache/AuthStateCache;", "redisTemplate", "Lorg/springframework/data/redis/core/StringRedisTemplate;", "keyPrefix", "", "(Lorg/springframework/data/redis/core/StringRedisTemplate;Ljava/lang/String;)V", "cache", "", "key", "value", "timeout", "", "containsKey", "", "get", "withPredix", "Companion", "cosec-oauth"})
public final class RedisAuthStateCache
implements AuthStateCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StringRedisTemplate redisTemplate;
    @NotNull
    private final String keyPrefix;
    private static final long DEFAULT_TIME_OUT = Duration.ofMinutes(3L).toMillis();
    @NotNull
    private static final String DEFAULT_KEY_PREFIX = "cosec:oauth:state:";

    public RedisAuthStateCache(@NotNull StringRedisTemplate redisTemplate, @NotNull String keyPrefix) {
        Intrinsics.checkNotNullParameter((Object)redisTemplate, (String)"redisTemplate");
        Intrinsics.checkNotNullParameter((Object)keyPrefix, (String)"keyPrefix");
        this.redisTemplate = redisTemplate;
        this.keyPrefix = keyPrefix;
    }

    public /* synthetic */ RedisAuthStateCache(StringRedisTemplate stringRedisTemplate, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = DEFAULT_KEY_PREFIX;
        }
        this(stringRedisTemplate, string);
    }

    private final String withPredix(String key) {
        return this.keyPrefix + key;
    }

    public void cache(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.cache(key, value, DEFAULT_TIME_OUT);
    }

    public void cache(@NotNull String key, @NotNull String value, long timeout) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.redisTemplate.opsForValue().set((Object)this.withPredix(key), (Object)value, timeout, TimeUnit.MILLISECONDS);
    }

    @NotNull
    public String get(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Object object = this.redisTemplate.opsForValue().get((Object)this.withPredix(key));
        Intrinsics.checkNotNull((Object)object);
        return (String)object;
    }

    public boolean containsKey(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Boolean bl = this.redisTemplate.hasKey((Object)this.withPredix(key));
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"redisTemplate.hasKey(withPredix(key))");
        return bl;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lme/ahoo/cosec/oauth/justauth/RedisAuthStateCache$Companion;", "", "()V", "DEFAULT_KEY_PREFIX", "", "DEFAULT_TIME_OUT", "", "cosec-oauth"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

