/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosec.oauth.client;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.MoreObjects;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.cosec.oauth.OAuthException;
import me.ahoo.cosec.oauth.OAuthUser;
import me.ahoo.cosec.oauth.client.OAuthClient;
import me.ahoo.cosec.oauth.client.OAuthClientCredentials;
import me.ahoo.cosid.IdGenerator;
import me.zhyd.oauth.enums.AuthUserGender;
import me.zhyd.oauth.model.AuthCallback;
import me.zhyd.oauth.model.AuthResponse;
import me.zhyd.oauth.model.AuthUser;
import me.zhyd.oauth.request.AuthRequest;
import org.jetbrains.annotations.NotNull;
import reactor.core.publisher.Mono;
import reactor.kotlin.core.publisher.MonoExtensionsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0003H\u0016J\u0006\u0010\u0002\u001a\u00020\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lme/ahoo/cosec/oauth/client/JustAuthClient;", "Lme/ahoo/cosec/oauth/client/OAuthClient;", "name", "", "authRequest", "Lme/zhyd/oauth/request/AuthRequest;", "idGenerator", "Lme/ahoo/cosid/IdGenerator;", "(Ljava/lang/String;Lme/zhyd/oauth/request/AuthRequest;Lme/ahoo/cosid/IdGenerator;)V", "getName", "()Ljava/lang/String;", "asGender", "Lme/ahoo/cosec/oauth/OAuthUser$Gender;", "authUserGender", "Lme/zhyd/oauth/enums/AuthUserGender;", "authenticate", "Lreactor/core/publisher/Mono;", "Lme/ahoo/cosec/oauth/OAuthUser;", "credentials", "Lme/ahoo/cosec/oauth/client/OAuthClientCredentials;", "authorizeUrl", "cosec-oauth"})
public final class JustAuthClient
implements OAuthClient {
    @NotNull
    private final String name;
    @NotNull
    private final AuthRequest authRequest;
    @NotNull
    private final IdGenerator idGenerator;

    public JustAuthClient(@NotNull String name, @NotNull AuthRequest authRequest, @NotNull IdGenerator idGenerator) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)authRequest, (String)"authRequest");
        Intrinsics.checkNotNullParameter((Object)idGenerator, (String)"idGenerator");
        this.name = name;
        this.authRequest = authRequest;
        this.idGenerator = idGenerator;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String authorizeUrl() {
        String string = this.authRequest.authorize(this.idGenerator.generateAsString());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"authRequest.authorize(id\u2026rator.generateAsString())");
        return string;
    }

    @Override
    @NotNull
    public Mono<OAuthUser> authenticate(@NotNull OAuthClientCredentials credentials) {
        Intrinsics.checkNotNullParameter((Object)((Object)credentials), (String)"credentials");
        Mono mono = Mono.defer(() -> JustAuthClient.authenticate$lambda$0(this, credentials));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"defer {\n            @Sup\u2026     ).toMono()\n        }");
        return mono;
    }

    private final OAuthUser.Gender asGender(AuthUserGender authUserGender) {
        OAuthUser.Gender gender;
        switch (WhenMappings.$EnumSwitchMapping$0[authUserGender.ordinal()]) {
            case 1: {
                gender = OAuthUser.Gender.MALE;
                break;
            }
            case 2: {
                gender = OAuthUser.Gender.FEMALE;
                break;
            }
            case 3: {
                gender = OAuthUser.Gender.UNKNOWN;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + authUserGender);
            }
        }
        return gender;
    }

    @NotNull
    public final String name() {
        return this.getName();
    }

    private static final Mono authenticate$lambda$0(JustAuthClient this$0, OAuthClientCredentials $credentials) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$credentials), (String)"$credentials");
        AuthResponse authResponse = this$0.authRequest.login((AuthCallback)$credentials);
        Intrinsics.checkNotNull((Object)authResponse, (String)"null cannot be cast to non-null type me.zhyd.oauth.model.AuthResponse<me.zhyd.oauth.model.AuthUser>");
        AuthResponse authResponse2 = authResponse;
        if (!authResponse2.ok()) {
            Object object = MoreObjects.firstNonNull((Object)authResponse2.getMsg(), (Object)String.valueOf(authResponse2.getCode()));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"firstNonNull(authRespons\u2026Response.code.toString())");
            throw new OAuthException((String)object);
        }
        AuthUser authUser = (AuthUser)authResponse2.getData();
        String string = authUser.getUuid();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"authUser.uuid");
        String string2 = authUser.getUsername();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"authUser.username");
        String string3 = authUser.getNickname();
        String string4 = authUser.getAvatar();
        String string5 = authUser.getEmail();
        String string6 = authUser.getLocation();
        AuthUserGender authUserGender = authUser.getGender();
        Intrinsics.checkNotNullExpressionValue((Object)authUserGender, (String)"authUser.gender");
        OAuthUser.Gender gender = this$0.asGender(authUserGender);
        JSONObject jSONObject = authUser.getRawUserInfo();
        Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"authUser.rawUserInfo");
        return MonoExtensionsKt.toMono((Object)new OAuthUser(string, string2, string3, string4, string5, string6, gender, (Map)jSONObject, this$0.getName()));
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AuthUserGender.values().length];
            try {
                nArray[AuthUserGender.MALE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AuthUserGender.FEMALE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AuthUserGender.UNKNOWN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

