/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosec.oauth.client;

import com.google.common.annotations.Beta;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.cosec.oauth.client.OAuthClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\u0005H\u0086\u0002J\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0005J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0006J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lme/ahoo/cosec/oauth/client/OAuthClientManager;", "", "()V", "clients", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lme/ahoo/cosec/oauth/client/OAuthClient;", "get", "client", "getRequired", "register", "", "authProvider", "Companion", "cosec-oauth"})
@Beta
public final class OAuthClientManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentHashMap<String, OAuthClient> clients = new ConcurrentHashMap();
    @JvmField
    @NotNull
    public static final OAuthClientManager INSTANCE = new OAuthClientManager();

    @Nullable
    public final OAuthClient get(@NotNull String client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        return this.clients.get(client);
    }

    @NotNull
    public final OAuthClient getRequired(@NotNull String client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        OAuthClient oAuthClient = this.get(client);
        if (oAuthClient == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        return oAuthClient;
    }

    public final void register(@NotNull String client, @NotNull OAuthClient authProvider) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)authProvider, (String)"authProvider");
        ((Map)this.clients).put(client, authProvider);
    }

    public final void register(@NotNull OAuthClient authProvider) {
        Intrinsics.checkNotNullParameter((Object)authProvider, (String)"authProvider");
        ((Map)this.clients).put(authProvider.getName(), authProvider);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lme/ahoo/cosec/oauth/client/OAuthClientManager$Companion;", "", "()V", "INSTANCE", "Lme/ahoo/cosec/oauth/client/OAuthClientManager;", "cosec-oauth"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

