/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosec.gateway;

import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import me.ahoo.cosec.api.authorization.Authorization;
import me.ahoo.cosec.api.authorization.AuthorizeResult;
import me.ahoo.cosec.api.context.SecurityContext;
import me.ahoo.cosec.api.context.request.Request;
import me.ahoo.cosec.api.principal.CoSecPrincipal;
import me.ahoo.cosec.context.SecurityContextParser;
import me.ahoo.cosec.context.SimpleSecurityContext;
import me.ahoo.cosec.context.request.RequestParser;
import me.ahoo.cosec.token.TokenVerificationException;
import me.ahoo.cosec.token.TokenVerificationExceptionKt;
import me.ahoo.cosec.webflux.ReactiveSecurityContexts;
import me.ahoo.cosec.webflux.ReactiveSecurityFilter;
import me.ahoo.cosec.webflux.ServerWebExchanges;
import org.jetbrains.annotations.NotNull;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.core.Ordered;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import reactor.kotlin.core.publisher.MonoExtensionsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B)\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0014"}, d2={"Lme/ahoo/cosec/gateway/AuthorizationGatewayFilter;", "Lorg/springframework/cloud/gateway/filter/GlobalFilter;", "Lorg/springframework/core/Ordered;", "Lme/ahoo/cosec/webflux/ReactiveSecurityFilter;", "securityContextParser", "Lme/ahoo/cosec/context/SecurityContextParser;", "Lorg/springframework/web/server/ServerWebExchange;", "requestParser", "Lme/ahoo/cosec/context/request/RequestParser;", "authorization", "Lme/ahoo/cosec/api/authorization/Authorization;", "(Lme/ahoo/cosec/context/SecurityContextParser;Lme/ahoo/cosec/context/request/RequestParser;Lme/ahoo/cosec/api/authorization/Authorization;)V", "filter", "Lreactor/core/publisher/Mono;", "Ljava/lang/Void;", "exchange", "chain", "Lorg/springframework/cloud/gateway/filter/GatewayFilterChain;", "getOrder", "", "cosec-gateway"})
@SourceDebugExtension(value={"SMAP\nAuthorizationGatewayFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AuthorizationGatewayFilter.kt\nme/ahoo/cosec/gateway/AuthorizationGatewayFilter\n+ 2 ReactiveSecurityFilter.kt\nme/ahoo/cosec/webflux/ReactiveSecurityFilter\n*L\n1#1,45:1\n43#2,11:46\n*S KotlinDebug\n*F\n+ 1 AuthorizationGatewayFilter.kt\nme/ahoo/cosec/gateway/AuthorizationGatewayFilter\n*L\n36#1:46,11\n*E\n"})
public final class AuthorizationGatewayFilter
extends ReactiveSecurityFilter
implements GlobalFilter,
Ordered {
    public AuthorizationGatewayFilter(@NotNull SecurityContextParser<ServerWebExchange> securityContextParser, @NotNull RequestParser<ServerWebExchange> requestParser, @NotNull Authorization authorization) {
        Intrinsics.checkNotNullParameter(securityContextParser, (String)"securityContextParser");
        Intrinsics.checkNotNullParameter(requestParser, (String)"requestParser");
        Intrinsics.checkNotNullParameter((Object)authorization, (String)"authorization");
        super(securityContextParser, requestParser, authorization);
    }

    @NotNull
    public Mono<Void> filter(@NotNull ServerWebExchange exchange, @NotNull GatewayFilterChain chain) {
        SecurityContext securityContext;
        Intrinsics.checkNotNullParameter((Object)exchange, (String)"exchange");
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        ReactiveSecurityFilter this_$iv = this;
        boolean $i$f$filterInternal = false;
        Ref.ObjectRef tokenVerificationException$iv = new Ref.ObjectRef();
        try {
            securityContext = this_$iv.getSecurityContextParser().parse((Object)exchange);
        }
        catch (TokenVerificationException verificationException$iv) {
            tokenVerificationException$iv.element = verificationException$iv;
            securityContext = SimpleSecurityContext.Companion.anonymous();
        }
        SecurityContext securityContext$iv = securityContext;
        ServerWebExchanges.setSecurityContext((ServerWebExchange)exchange, (SecurityContext)securityContext$iv);
        Request request$iv = this_$iv.getRequestParser().parse((Object)exchange);
        Function1 function1 = (Function1)new Function1<AuthorizeResult, Mono<? extends Void>>(exchange, securityContext$iv, this_$iv, tokenVerificationException$iv, chain){
            final /* synthetic */ ServerWebExchange $exchange;
            final /* synthetic */ SecurityContext $securityContext;
            final /* synthetic */ ReactiveSecurityFilter this$0;
            final /* synthetic */ Ref.ObjectRef $tokenVerificationException;
            final /* synthetic */ GatewayFilterChain $chain$inlined;
            {
                this.$exchange = $exchange;
                this.$securityContext = $securityContext;
                this.this$0 = $receiver;
                this.$tokenVerificationException = $tokenVerificationException;
                this.$chain$inlined = gatewayFilterChain;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final Mono<? extends Void> invoke(AuthorizeResult authorizeResult) {
                if (authorizeResult.getAuthorized()) {
                    void it;
                    ServerWebExchange serverWebExchange = this.$exchange.mutate().principal(MonoExtensionsKt.toMono((Object)this.$securityContext.getPrincipal())).build();
                    SecurityContext securityContext = this.$securityContext;
                    ServerWebExchange it2 = serverWebExchange;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"it");
                    ServerWebExchange serverWebExchange2 = it2;
                    ReactiveSecurityContexts reactiveSecurityContexts = ReactiveSecurityContexts.INSTANCE;
                    boolean bl2 = false;
                    Mono mono = this.$chain$inlined.filter((ServerWebExchange)it);
                    Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"chain.filter(it)");
                    return reactiveSecurityContexts.writeSecurityContext(mono, securityContext);
                }
                CoSecPrincipal principal = this.$securityContext.getPrincipal();
                if (!principal.authenticated()) {
                    this.$exchange.getResponse().setStatusCode(HttpStatus.UNAUTHORIZED);
                } else {
                    this.$exchange.getResponse().setStatusCode(HttpStatus.FORBIDDEN);
                }
                ServerHttpResponse serverHttpResponse = this.$exchange.getResponse();
                Intrinsics.checkNotNullExpressionValue((Object)serverHttpResponse, (String)"exchange.response");
                TokenVerificationException tokenVerificationException = (TokenVerificationException)((Object)this.$tokenVerificationException.element);
                if (tokenVerificationException == null || (tokenVerificationException = TokenVerificationExceptionKt.asAuthorizeResult((TokenVerificationException)tokenVerificationException)) == null) {
                    tokenVerificationException = authorizeResult;
                }
                Intrinsics.checkNotNullExpressionValue((Object)((Object)tokenVerificationException), (String)"tokenVerificationExcepti\u2026sult() ?: authorizeResult");
                return this.this$0.writeWithAuthorizeResult(serverHttpResponse, (AuthorizeResult)tokenVerificationException);
            }
        };
        Mono mono = this_$iv.getAuthorization().authorize(request$iv, securityContext$iv).flatMap(new Function(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ Object apply(Object p0) {
                return this.function.invoke(p0);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"inline fun filterInterna\u2026    )\n            }\n    }");
        return mono;
    }

    public int getOrder() {
        return -2147483638;
    }
}

