/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosec.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.cosec.api.policy.ActionMatcher;
import me.ahoo.cosec.configuration.JsonConfiguration;
import me.ahoo.cosec.policy.action.ActionMatcherFactory;
import me.ahoo.cosec.policy.action.ActionMatcherFactoryProvider;
import me.ahoo.cosec.policy.action.AllActionMatcher;
import me.ahoo.cosec.policy.action.PathActionMatcherFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lme/ahoo/cosec/serialization/JsonActionMatcherDeserializer;", "Lcom/fasterxml/jackson/databind/deser/std/StdDeserializer;", "Lme/ahoo/cosec/api/policy/ActionMatcher;", "<init>", "()V", "deserialize", "p", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "cosec-core"})
public final class JsonActionMatcherDeserializer
extends StdDeserializer<ActionMatcher> {
    @NotNull
    public static final JsonActionMatcherDeserializer INSTANCE = new JsonActionMatcherDeserializer();

    private JsonActionMatcherDeserializer() {
        super(ActionMatcher.class);
    }

    @NotNull
    public ActionMatcher deserialize(@NotNull JsonParser p, @NotNull DeserializationContext ctxt) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)ctxt, (String)"ctxt");
        JsonConfiguration actionConfiguration = (JsonConfiguration)p.getCodec().readValue(p, JsonConfiguration.class);
        if (actionConfiguration.isString() && Intrinsics.areEqual((Object)actionConfiguration.asString(), (Object)"*")) {
            return AllActionMatcher.Companion.getINSTANCE();
        }
        if (actionConfiguration.isString() || actionConfiguration.isArray()) {
            PathActionMatcherFactory pathActionMatcherFactory = PathActionMatcherFactory.Companion.getINSTANCE();
            Intrinsics.checkNotNull((Object)actionConfiguration);
            return pathActionMatcherFactory.create(actionConfiguration);
        }
        if (!actionConfiguration.isObject()) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Map.Entry field = (Map.Entry)actionConfiguration.getDelegate().fields().next();
        JsonConfiguration conditionConfiguration = (JsonConfiguration)((JsonNode)field.getValue()).traverse(p.getCodec()).readValueAs(JsonConfiguration.class);
        Object k = field.getKey();
        Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
        ActionMatcherFactory actionMatcherFactory = ActionMatcherFactoryProvider.INSTANCE.getRequired((String)k);
        Intrinsics.checkNotNull((Object)conditionConfiguration);
        return actionMatcherFactory.create(conditionConfiguration);
    }
}

