/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosec.policy.condition.limiter;

import com.google.common.util.concurrent.RateLimiter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.cosec.api.configuration.Configuration;
import me.ahoo.cosec.api.context.SecurityContext;
import me.ahoo.cosec.api.context.request.Request;
import me.ahoo.cosec.api.policy.ConditionMatcher;
import me.ahoo.cosec.policy.condition.limiter.TooManyRequestsException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lme/ahoo/cosec/policy/condition/limiter/RateLimiterConditionMatcher;", "Lme/ahoo/cosec/api/policy/ConditionMatcher;", "configuration", "Lme/ahoo/cosec/api/configuration/Configuration;", "<init>", "(Lme/ahoo/cosec/api/configuration/Configuration;)V", "getConfiguration", "()Lme/ahoo/cosec/api/configuration/Configuration;", "type", "", "getType", "()Ljava/lang/String;", "permitsPerSecond", "", "rateLimiter", "Lcom/google/common/util/concurrent/RateLimiter;", "match", "", "request", "Lme/ahoo/cosec/api/context/request/Request;", "securityContext", "Lme/ahoo/cosec/api/context/SecurityContext;", "cosec-core"})
public final class RateLimiterConditionMatcher
implements ConditionMatcher {
    @NotNull
    private final Configuration configuration;
    private final double permitsPerSecond;
    @NotNull
    private final RateLimiter rateLimiter;

    public RateLimiterConditionMatcher(@NotNull Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.configuration = configuration;
        Configuration configuration2 = this.getConfiguration().get("permitsPerSecond");
        if (configuration2 == null) {
            RateLimiterConditionMatcher rateLimiterConditionMatcher = this;
            boolean bl = false;
            RateLimiterConditionMatcher rateLimiterConditionMatcher2 = rateLimiterConditionMatcher;
            String string = "permitsPerSecond is required!";
            throw new IllegalArgumentException(string.toString());
        }
        this.permitsPerSecond = configuration2.asDouble();
        RateLimiter rateLimiter = RateLimiter.create((double)this.permitsPerSecond);
        Intrinsics.checkNotNullExpressionValue((Object)rateLimiter, (String)"create(...)");
        this.rateLimiter = rateLimiter;
    }

    @NotNull
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @NotNull
    public String getType() {
        return "rateLimiter";
    }

    public boolean match(@NotNull Request request, @NotNull SecurityContext securityContext) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)securityContext, (String)"securityContext");
        if (this.rateLimiter.tryAcquire()) {
            return true;
        }
        throw new TooManyRequestsException(null, 1, null);
    }
}

