/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosec.policy.action;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.cosec.api.configuration.Configuration;
import me.ahoo.cosec.api.context.SecurityContext;
import me.ahoo.cosec.api.context.request.Request;
import me.ahoo.cosec.policy.action.AbstractActionMatcher;
import me.ahoo.cosec.policy.action.PathActionMatcherKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.server.PathContainer;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lme/ahoo/cosec/policy/action/PathActionMatcher;", "Lme/ahoo/cosec/policy/action/AbstractActionMatcher;", "patternParser", "Lorg/springframework/web/util/pattern/PathPatternParser;", "pathPattern", "Lorg/springframework/web/util/pattern/PathPattern;", "configuration", "Lme/ahoo/cosec/api/configuration/Configuration;", "<init>", "(Lorg/springframework/web/util/pattern/PathPatternParser;Lorg/springframework/web/util/pattern/PathPattern;Lme/ahoo/cosec/api/configuration/Configuration;)V", "internalMatch", "", "request", "Lme/ahoo/cosec/api/context/request/Request;", "securityContext", "Lme/ahoo/cosec/api/context/SecurityContext;", "cosec-core"})
public final class PathActionMatcher
extends AbstractActionMatcher {
    @NotNull
    private final PathPatternParser patternParser;
    @NotNull
    private final PathPattern pathPattern;

    public PathActionMatcher(@NotNull PathPatternParser patternParser, @NotNull PathPattern pathPattern, @NotNull Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)patternParser, (String)"patternParser");
        Intrinsics.checkNotNullParameter((Object)pathPattern, (String)"pathPattern");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        super("path", configuration);
        this.patternParser = patternParser;
        this.pathPattern = pathPattern;
    }

    @Override
    public boolean internalMatch(@NotNull Request request, @NotNull SecurityContext securityContext) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)securityContext, (String)"securityContext");
        PathContainer pathContainer = PathContainer.parsePath((String)request.getPath(), (PathContainer.Options)this.patternParser.getPathOptions());
        boolean bl = false;
        PathPattern.PathMatchInfo pathMatchInfo = this.pathPattern.matchAndExtract(pathContainer);
        if (pathMatchInfo == null) {
            return false;
        }
        PathPattern.PathMatchInfo pathMatchInfo2 = pathMatchInfo;
        Map map = pathMatchInfo2.getUriVariables();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getUriVariables(...)");
        PathActionMatcherKt.setPathVariables(securityContext, map);
        return true;
    }
}

