/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosec.policy;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.ahoo.cosec.api.policy.Policy;
import me.ahoo.cosec.serialization.CoSecJsonSerializer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR!\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lme/ahoo/cosec/policy/LocalPolicyLoader;", "", "locations", "", "", "<init>", "(Ljava/util/Set;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "policies", "", "Lme/ahoo/cosec/api/policy/Policy;", "getPolicies", "()Ljava/util/List;", "policies$delegate", "Lkotlin/Lazy;", "loadPolicies", "Companion", "cosec-core"})
@SourceDebugExtension(value={"SMAP\nLocalPolicyLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalPolicyLoader.kt\nme/ahoo/cosec/policy/LocalPolicyLoader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,63:1\n1368#2:64\n1454#2,5:65\n1611#2,9:70\n1863#2:79\n1864#2:81\n1620#2:82\n1663#2,8:83\n1#3:80\n*S KotlinDebug\n*F\n+ 1 LocalPolicyLoader.kt\nme/ahoo/cosec/policy/LocalPolicyLoader\n*L\n34#1:64\n34#1:65,5\n46#1:70,9\n46#1:79\n46#1:81\n46#1:82\n58#1:83,8\n46#1:80\n*E\n"})
public final class LocalPolicyLoader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<String> locations;
    private final Logger log;
    @NotNull
    private final Lazy policies$delegate;
    @NotNull
    private static final ResourcePatternResolver resourceResolver = (ResourcePatternResolver)new PathMatchingResourcePatternResolver();

    public LocalPolicyLoader(@NotNull Set<String> locations) {
        Intrinsics.checkNotNullParameter(locations, (String)"locations");
        this.locations = locations;
        this.log = LoggerFactory.getLogger(LocalPolicyLoader.class);
        this.policies$delegate = LazyKt.lazy(() -> LocalPolicyLoader.policies_delegate$lambda$0(this));
    }

    @NotNull
    public final List<Policy> getPolicies() {
        Lazy lazy = this.policies$delegate;
        return (List)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final List<Policy> loadPolicies() {
        void $this$mapNotNullTo$iv$iv;
        Object list$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.locations;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list;
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (this.log.isInfoEnabled()) {
                this.log.info("Load Location [{}].", (Object)it);
            }
            try {
                Resource[] resourceArray = resourceResolver.getResources(it);
                Intrinsics.checkNotNullExpressionValue((Object)resourceArray, (String)"getResources(...)");
                list = ArraysKt.toList((Object[])resourceArray);
            }
            catch (FileNotFoundException e) {
                if (this.log.isErrorEnabled()) {
                    this.log.error(e.getMessage(), (Throwable)e);
                }
                list = CollectionsKt.emptyList();
            }
            list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$flatMapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        list$iv$iv = $this$forEach$iv$iv$iv.iterator();
        while (list$iv$iv.hasNext()) {
            Policy policy;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = list$iv$iv.next();
            boolean bl = false;
            Resource it = (Resource)element$iv$iv;
            boolean bl2 = false;
            if (this.log.isInfoEnabled()) {
                this.log.info("Load Policy [{}].", (Object)it);
            }
            try {
                policy = (Policy)CoSecJsonSerializer.INSTANCE.readValue(it.getContentAsByteArray(), Policy.class);
            }
            catch (Throwable e) {
                if (this.log.isErrorEnabled()) {
                    this.log.error(e.getMessage(), e);
                }
                policy = null;
            }
            if (policy == null) continue;
            Policy it$iv$iv = policy;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$distinctBy$iv = (List)destination$iv$iv;
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            Policy it = (Policy)e$iv;
            boolean bl = false;
            String key$iv = it.getId();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        return list$iv;
    }

    private static final List policies_delegate$lambda$0(LocalPolicyLoader this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.loadPolicies();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lme/ahoo/cosec/policy/LocalPolicyLoader$Companion;", "", "<init>", "()V", "resourceResolver", "Lorg/springframework/core/io/support/ResourcePatternResolver;", "cosec-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

