/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosec.policy;

import java.time.Duration;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.ahoo.cosec.api.policy.Policy;
import me.ahoo.cosec.authorization.PolicyRepository;
import me.ahoo.cosec.policy.LocalPolicyLoader;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.kotlin.core.publisher.MonoExtensionsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lme/ahoo/cosec/policy/LocalPolicyInitializer;", "", "localPolicyLoader", "Lme/ahoo/cosec/policy/LocalPolicyLoader;", "policyRepository", "Lme/ahoo/cosec/authorization/PolicyRepository;", "forceRefresh", "", "<init>", "(Lme/ahoo/cosec/policy/LocalPolicyLoader;Lme/ahoo/cosec/authorization/PolicyRepository;Z)V", "init", "", "initPolicy", "policy", "Lme/ahoo/cosec/api/policy/Policy;", "Companion", "cosec-core"})
@SourceDebugExtension(value={"SMAP\nLocalPolicyInitializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalPolicyInitializer.kt\nme/ahoo/cosec/policy/LocalPolicyInitializer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,77:1\n1863#2,2:78\n*S KotlinDebug\n*F\n+ 1 LocalPolicyInitializer.kt\nme/ahoo/cosec/policy/LocalPolicyInitializer\n*L\n40#1:78,2\n*E\n"})
public final class LocalPolicyInitializer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LocalPolicyLoader localPolicyLoader;
    @NotNull
    private final PolicyRepository policyRepository;
    private final boolean forceRefresh;
    private static final Logger log = LoggerFactory.getLogger(LocalPolicyInitializer.class);

    public LocalPolicyInitializer(@NotNull LocalPolicyLoader localPolicyLoader, @NotNull PolicyRepository policyRepository, boolean forceRefresh) {
        Intrinsics.checkNotNullParameter((Object)localPolicyLoader, (String)"localPolicyLoader");
        Intrinsics.checkNotNullParameter((Object)policyRepository, (String)"policyRepository");
        this.localPolicyLoader = localPolicyLoader;
        this.policyRepository = policyRepository;
        this.forceRefresh = forceRefresh;
    }

    public final void init() {
        if (log.isInfoEnabled()) {
            log.info("Initialize local policy to PolicyRepository.");
        }
        List<Policy> policies = this.localPolicyLoader.getPolicies();
        Iterable $this$forEach$iv = policies;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Policy it = (Policy)element$iv;
            boolean bl = false;
            this.initPolicy(it);
        }
    }

    private final void initPolicy(Policy policy) {
        if (this.forceRefresh) {
            if (log.isInfoEnabled()) {
                log.info("Force Refresh Init Policy - Local Policy[{}].", (Object)policy.getId());
            }
            this.policyRepository.setPolicy(policy).block(Duration.ofSeconds(10L));
            return;
        }
        MonoExtensionsKt.switchIfEmpty(this.policyRepository.getPolicies(SetsKt.setOf((Object)policy.getId())), LocalPolicyInitializer::initPolicy$lambda$1).flatMap(arg_0 -> LocalPolicyInitializer.initPolicy$lambda$3(arg_0 -> LocalPolicyInitializer.initPolicy$lambda$2(policy, this, arg_0), arg_0)).doOnError(arg_0 -> LocalPolicyInitializer.initPolicy$lambda$5(arg_0 -> LocalPolicyInitializer.initPolicy$lambda$4(policy, arg_0), arg_0)).block(Duration.ofSeconds(10L));
    }

    private static final Mono initPolicy$lambda$1() {
        return MonoExtensionsKt.toMono((Object)CollectionsKt.emptyList());
    }

    private static final Mono initPolicy$lambda$2(Policy $policy, LocalPolicyInitializer this$0, List policies) {
        Intrinsics.checkNotNullParameter((Object)$policy, (String)"$policy");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (policies.isEmpty()) {
            if (log.isInfoEnabled()) {
                log.info("Init Policy - [{}].", (Object)$policy.getId());
            }
            return this$0.policyRepository.setPolicy($policy);
        }
        if (log.isInfoEnabled()) {
            log.info("Init Policy - [{}] already exists,Ignore setting policy.", (Object)$policy.getId());
        }
        return Mono.empty();
    }

    private static final Mono initPolicy$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Mono)$tmp0.invoke(p0);
    }

    private static final Unit initPolicy$lambda$4(Policy $policy, Throwable error) {
        Intrinsics.checkNotNullParameter((Object)$policy, (String)"$policy");
        if (log.isErrorEnabled()) {
            log.error("Init Policy - [{}] failed.", (Object)$policy.getId(), (Object)error);
        }
        return Unit.INSTANCE;
    }

    private static final void initPolicy$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lme/ahoo/cosec/policy/LocalPolicyInitializer$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "cosec-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

