/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosec.configuration;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.Closeable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.ahoo.cosec.Delegated;
import me.ahoo.cosec.api.configuration.Configuration;
import me.ahoo.cosec.serialization.CoSecJsonSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 (2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0001(B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00010\u000fH\u0016J\u0014\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00010\u0011H\u0016J\b\u0010\u0012\u001a\u00020\rH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J!\u0010\u001b\u001a\u0002H\u001c\"\u0004\b\u0000\u0010\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001c0\u001eH\u0016\u00a2\u0006\u0002\u0010\u001fR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010!R\u0014\u0010#\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010!R\u0014\u0010$\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010!R\u0014\u0010%\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010!R\u0014\u0010&\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010!R\u0014\u0010'\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010!\u00a8\u0006)"}, d2={"Lme/ahoo/cosec/configuration/JsonConfiguration;", "Lme/ahoo/cosec/api/configuration/Configuration;", "Lme/ahoo/cosec/Delegated;", "Lcom/fasterxml/jackson/databind/JsonNode;", "delegate", "objectCodec", "Lcom/fasterxml/jackson/core/ObjectCodec;", "<init>", "(Lcom/fasterxml/jackson/databind/JsonNode;Lcom/fasterxml/jackson/core/ObjectCodec;)V", "getDelegate", "()Lcom/fasterxml/jackson/databind/JsonNode;", "get", "key", "", "asList", "", "asMap", "", "asString", "asBoolean", "", "asInt", "", "asLong", "", "asDouble", "", "asObject", "T", "objectClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)Ljava/lang/Object;", "isString", "()Z", "isBoolean", "isInt", "isLong", "isDouble", "isArray", "isObject", "Companion", "cosec-core"})
@SourceDebugExtension(value={"SMAP\nJsonConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonConfiguration.kt\nme/ahoo/cosec/configuration/JsonConfiguration\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,114:1\n1#2:115\n*E\n"})
public final class JsonConfiguration
implements Configuration,
Delegated<JsonNode> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JsonNode delegate;
    @NotNull
    private final ObjectCodec objectCodec;
    @NotNull
    private static final Lazy<JsonConfiguration> NULL$delegate = LazyKt.lazy(JsonConfiguration::NULL_delegate$lambda$4);

    public JsonConfiguration(@NotNull JsonNode delegate, @NotNull ObjectCodec objectCodec) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)objectCodec, (String)"objectCodec");
        this.delegate = delegate;
        this.objectCodec = objectCodec;
    }

    @Override
    @NotNull
    public JsonNode getDelegate() {
        return this.delegate;
    }

    @Nullable
    public Configuration get(@NotNull String key) {
        JsonConfiguration jsonConfiguration;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        JsonNode jsonNode = this.getDelegate().get(key);
        if (jsonNode != null) {
            JsonNode it = jsonNode;
            boolean bl = false;
            jsonConfiguration = new JsonConfiguration(it, this.objectCodec);
        } else {
            jsonConfiguration = null;
        }
        return jsonConfiguration;
    }

    @NotNull
    public List<Configuration> asList() {
        List list;
        List $this$asList_u24lambda_u241 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        Iterator elements = this.getDelegate().elements();
        while (elements.hasNext()) {
            Object e = elements.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            $this$asList_u24lambda_u241.add(new JsonConfiguration((JsonNode)e, this.objectCodec));
        }
        return CollectionsKt.build((List)list);
    }

    @NotNull
    public Map<String, Configuration> asMap() {
        Map map;
        Map $this$asMap_u24lambda_u242 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        Iterator fields = this.getDelegate().fields();
        while (fields.hasNext()) {
            Map.Entry field = (Map.Entry)fields.next();
            Object k = field.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
            Object v = field.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
            $this$asMap_u24lambda_u242.put(k, new JsonConfiguration((JsonNode)v, this.objectCodec));
        }
        return MapsKt.build((Map)map);
    }

    @NotNull
    public String asString() {
        String string = this.getDelegate().asText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asText(...)");
        return string;
    }

    public boolean asBoolean() {
        return this.getDelegate().asBoolean();
    }

    public int asInt() {
        return this.getDelegate().asInt();
    }

    public long asLong() {
        return this.getDelegate().asLong();
    }

    public double asDouble() {
        return this.getDelegate().asDouble();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T asObject(@NotNull Class<T> objectClass) {
        Object object;
        Intrinsics.checkNotNullParameter(objectClass, (String)"objectClass");
        Closeable closeable = (Closeable)this.getDelegate().traverse(this.objectCodec);
        Throwable throwable = null;
        try {
            JsonParser it = (JsonParser)closeable;
            boolean bl = false;
            object = it.readValueAs(objectClass);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return (T)object;
    }

    public boolean isString() {
        return this.getDelegate().isTextual();
    }

    public boolean isBoolean() {
        return this.getDelegate().isBoolean();
    }

    public boolean isInt() {
        return this.getDelegate().isInt();
    }

    public boolean isLong() {
        return this.getDelegate().isLong();
    }

    public boolean isDouble() {
        return this.getDelegate().isDouble();
    }

    public boolean isArray() {
        return this.getDelegate().isArray();
    }

    public boolean isObject() {
        return this.getDelegate().isObject();
    }

    private static final JsonConfiguration NULL_delegate$lambda$4() {
        NullNode nullNode = NullNode.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)nullNode, (String)"getInstance(...)");
        return new JsonConfiguration((JsonNode)nullNode, (ObjectCodec)CoSecJsonSerializer.INSTANCE);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\n\u001a\u00020\u0005J\u0014\u0010\u000b\u001a\u00020\u0005*\f\u0012\u0004\u0012\u00020\r\u0012\u0002\b\u00030\fJ\n\u0010\u000b\u001a\u00020\u0005*\u00020\rR\u001b\u0010\u0004\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lme/ahoo/cosec/configuration/JsonConfiguration$Companion;", "", "<init>", "()V", "NULL", "Lme/ahoo/cosec/configuration/JsonConfiguration;", "getNULL", "()Lme/ahoo/cosec/configuration/JsonConfiguration;", "NULL$delegate", "Lkotlin/Lazy;", "newPojoConfiguration", "asConfiguration", "", "", "cosec-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JsonConfiguration getNULL() {
            Lazy lazy = NULL$delegate;
            return (JsonConfiguration)lazy.getValue();
        }

        @NotNull
        public final JsonConfiguration newPojoConfiguration() {
            return new JsonConfiguration((JsonNode)new ObjectNode(CoSecJsonSerializer.INSTANCE.getNodeFactory()), (ObjectCodec)CoSecJsonSerializer.INSTANCE);
        }

        @NotNull
        public final JsonConfiguration asConfiguration(@NotNull Map<String, ?> $this$asConfiguration) {
            Intrinsics.checkNotNullParameter($this$asConfiguration, (String)"<this>");
            String jsonString = CoSecJsonSerializer.INSTANCE.writeValueAsString($this$asConfiguration);
            JsonNode jsonNode = CoSecJsonSerializer.INSTANCE.readTree(jsonString);
            Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"readTree(...)");
            return new JsonConfiguration(jsonNode, (ObjectCodec)CoSecJsonSerializer.INSTANCE);
        }

        @NotNull
        public final JsonConfiguration asConfiguration(@NotNull String $this$asConfiguration) {
            Intrinsics.checkNotNullParameter((Object)$this$asConfiguration, (String)"<this>");
            return new JsonConfiguration((JsonNode)new TextNode($this$asConfiguration), (ObjectCodec)CoSecJsonSerializer.INSTANCE);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

