/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosec.authentication;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.cosec.api.authentication.Authentication;
import me.ahoo.cosec.api.authentication.AuthenticationProvider;
import me.ahoo.cosec.api.authentication.Credentials;
import me.ahoo.cosec.api.principal.CoSecPrincipal;
import org.jetbrains.annotations.NotNull;
import reactor.core.publisher.Mono;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J&\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\r2\u000e\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lme/ahoo/cosec/authentication/CompositeAuthentication;", "Lme/ahoo/cosec/api/authentication/Authentication;", "Lme/ahoo/cosec/api/authentication/Credentials;", "Lme/ahoo/cosec/api/principal/CoSecPrincipal;", "authenticationProvider", "Lme/ahoo/cosec/api/authentication/AuthenticationProvider;", "<init>", "(Lme/ahoo/cosec/api/authentication/AuthenticationProvider;)V", "supportCredentials", "Ljava/lang/Class;", "getSupportCredentials", "()Ljava/lang/Class;", "authenticate", "Lreactor/core/publisher/Mono;", "credentials", "credentialsType", "cosec-core"})
public final class CompositeAuthentication
implements Authentication<Credentials, CoSecPrincipal> {
    @NotNull
    private final AuthenticationProvider authenticationProvider;

    public CompositeAuthentication(@NotNull AuthenticationProvider authenticationProvider) {
        Intrinsics.checkNotNullParameter((Object)authenticationProvider, (String)"authenticationProvider");
        this.authenticationProvider = authenticationProvider;
    }

    @NotNull
    public Class<Credentials> getSupportCredentials() {
        return Credentials.class;
    }

    @NotNull
    public Mono<? extends CoSecPrincipal> authenticate(@NotNull Credentials credentials) {
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        Class<?> credentialsType = credentials.getClass();
        return this.authenticate(credentialsType, credentials);
    }

    @NotNull
    public final Mono<? extends CoSecPrincipal> authenticate(@NotNull Class<? extends Credentials> credentialsType, @NotNull Credentials credentials) {
        Intrinsics.checkNotNullParameter(credentialsType, (String)"credentialsType");
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        return this.authenticationProvider.getRequired(credentialsType).authenticate(credentials);
    }
}

