/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosec.policy.action;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.cosec.api.configuration.Configuration;
import me.ahoo.cosec.api.context.SecurityContext;
import me.ahoo.cosec.api.context.request.Request;
import me.ahoo.cosec.policy.Expression;
import me.ahoo.cosec.policy.ExpressionKt;
import me.ahoo.cosec.policy.action.AbstractActionMatcher;
import me.ahoo.cosec.policy.action.PathActionMatcherKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.server.PathContainer;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lme/ahoo/cosec/policy/action/ReplaceablePathActionMatcher;", "Lme/ahoo/cosec/policy/action/AbstractActionMatcher;", "patternParser", "Lorg/springframework/web/util/pattern/PathPatternParser;", "pattern", "", "configuration", "Lme/ahoo/cosec/api/configuration/Configuration;", "(Lorg/springframework/web/util/pattern/PathPatternParser;Ljava/lang/String;Lme/ahoo/cosec/api/configuration/Configuration;)V", "expression", "Lme/ahoo/cosec/policy/Expression;", "internalMatch", "", "request", "Lme/ahoo/cosec/api/context/request/Request;", "securityContext", "Lme/ahoo/cosec/api/context/SecurityContext;", "cosec-core"})
public final class ReplaceablePathActionMatcher
extends AbstractActionMatcher {
    @NotNull
    private final PathPatternParser patternParser;
    @NotNull
    private final String pattern;
    @NotNull
    private final Expression<String> expression;

    public ReplaceablePathActionMatcher(@NotNull PathPatternParser patternParser, @NotNull String pattern, @NotNull Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)patternParser, (String)"patternParser");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        super("path", configuration);
        this.patternParser = patternParser;
        this.pattern = pattern;
        this.expression = ExpressionKt.asTemplateExpression(this.pattern);
    }

    @Override
    public boolean internalMatch(@NotNull Request request, @NotNull SecurityContext securityContext) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)securityContext, (String)"securityContext");
        String string = this.expression.getValue(securityContext);
        if (string == null) {
            String string2 = "Required value was null.";
            throw new IllegalArgumentException(string2.toString());
        }
        String pathPattern = string;
        PathContainer pathContainer = PathContainer.parsePath((String)request.getPath());
        Intrinsics.checkNotNullExpressionValue((Object)pathContainer, (String)"parsePath(...)");
        PathContainer pathContainer2 = pathContainer;
        PathPattern it = this.patternParser.parse(pathPattern);
        boolean bl = false;
        PathPattern.PathMatchInfo pathMatchInfo = it.matchAndExtract(pathContainer2);
        if (pathMatchInfo == null) {
            return false;
        }
        PathPattern.PathMatchInfo pathMatchInfo2 = pathMatchInfo;
        Intrinsics.checkNotNull((Object)pathMatchInfo2);
        PathPattern.PathMatchInfo pathMatchInfo3 = pathMatchInfo2;
        Map map = pathMatchInfo3.getUriVariables();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getUriVariables(...)");
        PathActionMatcherKt.setPathVariables(securityContext, map);
        return true;
    }
}

