/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosec.policy;

import java.time.Duration;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.ahoo.cosec.api.policy.Policy;
import me.ahoo.cosec.authorization.PolicyRepository;
import me.ahoo.cosec.policy.LocalPolicyInitializer;
import me.ahoo.cosec.policy.LocalPolicyLoader;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.kotlin.core.publisher.MonoExtensionsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lme/ahoo/cosec/policy/LocalPolicyInitializer;", "", "localPolicyLoader", "Lme/ahoo/cosec/policy/LocalPolicyLoader;", "policyRepository", "Lme/ahoo/cosec/authorization/PolicyRepository;", "(Lme/ahoo/cosec/policy/LocalPolicyLoader;Lme/ahoo/cosec/authorization/PolicyRepository;)V", "init", "", "initPolicy", "policy", "Lme/ahoo/cosec/api/policy/Policy;", "Companion", "cosec-core"})
@SourceDebugExtension(value={"SMAP\nLocalPolicyInitializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalPolicyInitializer.kt\nme/ahoo/cosec/policy/LocalPolicyInitializer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,65:1\n1855#2,2:66\n*S KotlinDebug\n*F\n+ 1 LocalPolicyInitializer.kt\nme/ahoo/cosec/policy/LocalPolicyInitializer\n*L\n39#1:66,2\n*E\n"})
public final class LocalPolicyInitializer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LocalPolicyLoader localPolicyLoader;
    @NotNull
    private final PolicyRepository policyRepository;
    private static final Logger log = LoggerFactory.getLogger(LocalPolicyInitializer.class);

    public LocalPolicyInitializer(@NotNull LocalPolicyLoader localPolicyLoader, @NotNull PolicyRepository policyRepository) {
        Intrinsics.checkNotNullParameter((Object)localPolicyLoader, (String)"localPolicyLoader");
        Intrinsics.checkNotNullParameter((Object)policyRepository, (String)"policyRepository");
        this.localPolicyLoader = localPolicyLoader;
        this.policyRepository = policyRepository;
    }

    public final void init() {
        if (log.isInfoEnabled()) {
            log.info("Initialize local policy to PolicyRepository.");
        }
        List<Policy> policies2 = this.localPolicyLoader.getPolicies();
        Iterable $this$forEach$iv = policies2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Policy it = (Policy)element$iv;
            boolean bl = false;
            this.initPolicy(it);
        }
    }

    private final void initPolicy(Policy policy) {
        MonoExtensionsKt.switchIfEmpty(this.policyRepository.getPolicies(SetsKt.setOf((Object)policy.getId())), (Function0)initPolicy.1.INSTANCE).flatMap(arg_0 -> LocalPolicyInitializer.initPolicy$lambda$1((Function1)new Function1<List<? extends Policy>, Mono<? extends Void>>(this, policy){
            final /* synthetic */ LocalPolicyInitializer this$0;
            final /* synthetic */ Policy $policy;
            {
                this.this$0 = $receiver;
                this.$policy = $policy;
                super(1);
            }

            public final Mono<? extends Void> invoke(List<? extends Policy> policies2) {
                if (policies2.isEmpty()) {
                    return LocalPolicyInitializer.access$getPolicyRepository$p(this.this$0).setPolicy(this.$policy);
                }
                if (LocalPolicyInitializer.access$getLog$cp().isInfoEnabled()) {
                    LocalPolicyInitializer.access$getLog$cp().info("Init - [{}] already exists,Ignore setting policy.", (Object)this.$policy.getId());
                }
                return Mono.empty();
            }
        }, arg_0)).doOnError(arg_0 -> LocalPolicyInitializer.initPolicy$lambda$2((Function1)new Function1<Throwable, Unit>(policy){
            final /* synthetic */ Policy $policy;
            {
                this.$policy = $policy;
                super(1);
            }

            public final void invoke(Throwable error) {
                if (LocalPolicyInitializer.access$getLog$cp().isErrorEnabled()) {
                    LocalPolicyInitializer.access$getLog$cp().error("Init - Policy[{}] failed.", (Object)this.$policy.getId(), (Object)error);
                }
            }
        }, arg_0)).block(Duration.ofSeconds(10L));
    }

    private static final Mono initPolicy$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Mono)$tmp0.invoke(p0);
    }

    private static final void initPolicy$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ PolicyRepository access$getPolicyRepository$p(LocalPolicyInitializer $this) {
        return $this.policyRepository;
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lme/ahoo/cosec/policy/LocalPolicyInitializer$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "cosec-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

