/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosec.policy;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.ahoo.cosec.api.policy.Policy;
import me.ahoo.cosec.policy.LocalPolicyLoader;
import me.ahoo.cosec.serialization.CoSecJsonSerializer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ResourceUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lme/ahoo/cosec/policy/LocalPolicyLoader;", "", "policyPaths", "", "", "(Ljava/util/Set;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "policies", "", "Lme/ahoo/cosec/api/policy/Policy;", "getPolicies", "()Ljava/util/List;", "policies$delegate", "Lkotlin/Lazy;", "loadPolicies", "Companion", "cosec-core"})
@SourceDebugExtension(value={"SMAP\nLocalPolicyLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalPolicyLoader.kt\nme/ahoo/cosec/policy/LocalPolicyLoader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,73:1\n1360#2:74\n1446#2,5:75\n1603#2,9:80\n1855#2:89\n1856#2:91\n1612#2:92\n1655#2,8:93\n1#3:90\n*S KotlinDebug\n*F\n+ 1 LocalPolicyLoader.kt\nme/ahoo/cosec/policy/LocalPolicyLoader\n*L\n34#1:74\n34#1:75,5\n54#1:80,9\n54#1:89\n54#1:91\n54#1:92\n68#1:93,8\n54#1:90\n*E\n"})
public final class LocalPolicyLoader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<String> policyPaths;
    private final Logger log;
    @NotNull
    private final Lazy policies$delegate;
    @NotNull
    private static final String POLICY_EXTENSION = "json";

    public LocalPolicyLoader(@NotNull Set<String> policyPaths) {
        Intrinsics.checkNotNullParameter(policyPaths, (String)"policyPaths");
        this.policyPaths = policyPaths;
        this.log = LoggerFactory.getLogger(LocalPolicyLoader.class);
        this.policies$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends Policy>>(this){
            final /* synthetic */ LocalPolicyLoader this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final List<Policy> invoke() {
                return LocalPolicyLoader.access$loadPolicies(this.this$0);
            }
        }));
    }

    @NotNull
    public final List<Policy> getPolicies() {
        Lazy lazy = this.policies$delegate;
        return (List)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final List<Policy> loadPolicies() {
        void $this$mapNotNullTo$iv$iv;
        Object list$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.policyPaths;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Object object;
            block17: {
                File file;
                String path = (String)element$iv$iv;
                boolean bl = false;
                try {
                    file = ResourceUtils.getFile((String)path);
                }
                catch (FileNotFoundException ex) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error(ex.getMessage(), (Throwable)ex);
                    }
                    object = CollectionsKt.emptyList();
                    break block17;
                }
                Object object2 = file;
                Intrinsics.checkNotNull((Object)object2);
                File policyFile = object2;
                if (!policyFile.isDirectory()) {
                    object = CollectionsKt.listOf((Object)policyFile);
                } else {
                    object2 = Files.walk(policyFile.toPath(), new FileVisitOption[0]).filter(arg_0 -> LocalPolicyLoader.loadPolicies$lambda$2$lambda$0(loadPolicies.policyFiles.1.1.INSTANCE, arg_0)).map(arg_0 -> LocalPolicyLoader.loadPolicies$lambda$2$lambda$1(loadPolicies.policyFiles.1.2.INSTANCE, arg_0)).toList();
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"toList(...)");
                    object = object2;
                }
            }
            list$iv$iv = (Iterable)object;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List policyFiles2 = (List)destination$iv$iv;
        Iterable $this$mapNotNull$iv = policyFiles2;
        boolean $i$f$mapNotNull = false;
        $this$flatMapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        list$iv$iv = $this$forEach$iv$iv$iv.iterator();
        while (list$iv$iv.hasNext()) {
            Policy policy;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = list$iv$iv.next();
            boolean bl = false;
            File file = (File)element$iv$iv;
            boolean bl2 = false;
            if (this.log.isInfoEnabled()) {
                this.log.info("Load Policy [{}].", (Object)file);
            }
            try {
                Closeable closeable = file.toURI().toURL().openStream();
                Throwable throwable = null;
                try {
                    InputStream it = (InputStream)closeable;
                    boolean bl3 = false;
                    Policy policy2 = (Policy)CoSecJsonSerializer.INSTANCE.readValue(it, Policy.class);
                    policy = policy2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (Throwable e) {
                if (this.log.isErrorEnabled()) {
                    this.log.error(e.getMessage(), e);
                }
                policy = null;
            }
            if (policy == null) continue;
            Policy it$iv$iv = policy;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$distinctBy$iv = (List)destination$iv$iv;
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            Policy it = (Policy)e$iv;
            boolean bl = false;
            String key$iv = it.getId();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        return list$iv;
    }

    private static final boolean loadPolicies$lambda$2$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final File loadPolicies$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (File)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ List access$loadPolicies(LocalPolicyLoader $this) {
        return $this.loadPolicies();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lme/ahoo/cosec/policy/LocalPolicyLoader$Companion;", "", "()V", "POLICY_EXTENSION", "", "cosec-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

