/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosec.authorization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.ahoo.cosec.api.authorization.Authorization;
import me.ahoo.cosec.api.authorization.AuthorizeResult;
import me.ahoo.cosec.api.context.SecurityContext;
import me.ahoo.cosec.api.context.request.Request;
import me.ahoo.cosec.api.permission.AppRolePermission;
import me.ahoo.cosec.api.permission.Permission;
import me.ahoo.cosec.api.policy.Effect;
import me.ahoo.cosec.api.policy.Policy;
import me.ahoo.cosec.api.policy.Statement;
import me.ahoo.cosec.api.policy.VerifyResult;
import me.ahoo.cosec.api.principal.CoSecPrincipal;
import me.ahoo.cosec.authorization.AppRolePermissionRepository;
import me.ahoo.cosec.authorization.PolicyRepository;
import me.ahoo.cosec.authorization.PolicyVerifyContext;
import me.ahoo.cosec.authorization.RoleVerifyContext;
import me.ahoo.cosec.authorization.VerifyContext;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.kotlin.core.publisher.MonoExtensionsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\"\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J(\u0010\u0013\u001a\u0004\u0018\u00010\u000f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\rH\u0002J\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000f0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lme/ahoo/cosec/authorization/SimpleAuthorization;", "Lme/ahoo/cosec/api/authorization/Authorization;", "policyRepository", "Lme/ahoo/cosec/authorization/PolicyRepository;", "appRolePermissionRepository", "Lme/ahoo/cosec/authorization/AppRolePermissionRepository;", "(Lme/ahoo/cosec/authorization/PolicyRepository;Lme/ahoo/cosec/authorization/AppRolePermissionRepository;)V", "authorize", "Lreactor/core/publisher/Mono;", "Lme/ahoo/cosec/api/authorization/AuthorizeResult;", "request", "Lme/ahoo/cosec/api/context/request/Request;", "context", "Lme/ahoo/cosec/api/context/SecurityContext;", "verifyAppRolePermission", "Lme/ahoo/cosec/authorization/VerifyContext;", "appRolePermission", "Lme/ahoo/cosec/api/permission/AppRolePermission;", "verifyGlobalPolicies", "verifyPolicies", "policies", "", "Lme/ahoo/cosec/api/policy/Policy;", "securityContext", "verifyPrincipalPolicies", "verifyRoot", "Lme/ahoo/cosec/api/policy/VerifyResult;", "Companion", "cosec-core"})
@SourceDebugExtension(value={"SMAP\nSimpleAuthorization.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpleAuthorization.kt\nme/ahoo/cosec/authorization/SimpleAuthorization\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,222:1\n766#2:223\n857#2,2:224\n1855#2:226\n766#2:227\n857#2,2:228\n1864#2,3:230\n1856#2:233\n1855#2:234\n766#2:235\n857#2,2:236\n1864#2,3:238\n1856#2:241\n766#2:243\n857#2,2:244\n1855#2,2:246\n766#2:250\n857#2,2:251\n1855#2,2:253\n215#3:242\n216#3:248\n215#3:249\n216#3:255\n*S KotlinDebug\n*F\n+ 1 SimpleAuthorization.kt\nme/ahoo/cosec/authorization/SimpleAuthorization\n*L\n50#1:223\n50#1:224,2\n54#1:226\n55#1:227\n55#1:228,2\n57#1:230,3\n54#1:233\n75#1:234\n76#1:235\n76#1:236,2\n78#1:238,3\n75#1:241\n112#1:243\n112#1:244,2\n114#1:246,2\n134#1:250\n134#1:251,2\n136#1:253,2\n109#1:242\n109#1:248\n131#1:249\n131#1:255\n*E\n"})
public final class SimpleAuthorization
implements Authorization {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PolicyRepository policyRepository;
    @NotNull
    private final AppRolePermissionRepository appRolePermissionRepository;
    private static final Logger log = LoggerFactory.getLogger(SimpleAuthorization.class);

    public SimpleAuthorization(@NotNull PolicyRepository policyRepository, @NotNull AppRolePermissionRepository appRolePermissionRepository) {
        Intrinsics.checkNotNullParameter((Object)policyRepository, (String)"policyRepository");
        Intrinsics.checkNotNullParameter((Object)appRolePermissionRepository, (String)"appRolePermissionRepository");
        this.policyRepository = policyRepository;
        this.appRolePermissionRepository = appRolePermissionRepository;
    }

    /*
     * WARNING - void declaration
     */
    private final VerifyContext verifyPolicies(List<? extends Policy> policies, Request request, SecurityContext securityContext) {
        VerifyResult verifyResult;
        void statement;
        void $this$forEachIndexed$iv;
        int index$iv22;
        Object element$iv$iv3;
        Object destination$iv$iv;
        Iterable $this$filter$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv2 = policies;
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
            Policy policy = (Policy)element$iv$iv2;
            boolean bl2 = false;
            if (!policy.getCondition().match(request, securityContext)) continue;
            destination$iv$iv2.add(element$iv$iv2);
        }
        List matchedPolicies = (List)destination$iv$iv2;
        Iterable $this$forEach$iv = matchedPolicies;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$filterTo$iv$iv2;
            Policy policy = (Policy)element$iv;
            boolean bl = false;
            $this$filter$iv = policy.getStatements();
            boolean $i$f$filter2 = false;
            Iterable bl2 = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv3 : $this$filterTo$iv$iv2) {
                Statement statement2 = (Statement)element$iv$iv3;
                boolean bl3 = false;
                if (!(statement2.getEffect() == Effect.DENY)) continue;
                destination$iv$iv.add(element$iv$iv3);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEachIndexed = false;
            index$iv22 = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                int n;
                if ((n = index$iv22++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                element$iv$iv3 = (Statement)item$iv;
                int index = n;
                boolean bl4 = false;
                verifyResult = statement.verify(request, securityContext);
                if (verifyResult != VerifyResult.EXPLICIT_DENY) continue;
                if (log.isDebugEnabled()) {
                    log.debug("Verify [" + request + "] [" + securityContext + "] matched Policy[" + policy.getId() + "] Statement[" + index + "][" + statement.getName() + "] - [Explicit Deny].");
                }
                return new PolicyVerifyContext(policy, index, (Statement)statement, verifyResult);
            }
        }
        $this$forEach$iv = matchedPolicies;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$filterTo$iv$iv3;
            Policy policy = (Policy)element$iv;
            boolean bl = false;
            $this$filter$iv = policy.getStatements();
            boolean $i$f$filter3 = false;
            Iterable index$iv22 = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo3 = false;
            for (Object element$iv$iv3 : $this$filterTo$iv$iv3) {
                Statement statement3 = (Statement)element$iv$iv3;
                boolean bl5 = false;
                if (!(statement3.getEffect() == Effect.ALLOW)) continue;
                destination$iv$iv.add(element$iv$iv3);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEachIndexed = false;
            index$iv22 = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                int n;
                if ((n = index$iv22++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                element$iv$iv3 = (Statement)item$iv;
                int index = n;
                boolean bl6 = false;
                verifyResult = statement.verify(request, securityContext);
                if (verifyResult != VerifyResult.ALLOW) continue;
                if (log.isDebugEnabled()) {
                    log.debug("Verify [" + request + "] [" + securityContext + "] matched Policy[" + policy.getId() + "] Statement[" + index + "][" + statement.getName() + "] - [Allow].");
                }
                return new PolicyVerifyContext(policy, index, (Statement)statement, verifyResult);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final VerifyContext verifyAppRolePermission(AppRolePermission appRolePermission, Request request, SecurityContext context) {
        VerifyResult verifyResult;
        void $this$forEach$iv;
        boolean $i$f$forEach;
        Object element$iv$iv;
        Object $this$filterTo$iv$iv;
        Collection destination$iv$iv;
        boolean $i$f$filter;
        Iterable $this$filter$iv;
        List permissions;
        String roleId;
        Map.Entry rolePermissionEntry;
        Map.Entry element$iv;
        if (!appRolePermission.getAppPermission().getCondition().match(request, context)) {
            return null;
        }
        Map $this$forEach$iv2 = appRolePermission.getRolePermissionIndexer();
        boolean $i$f$forEach2 = false;
        Iterator iterator = $this$forEach$iv2.entrySet().iterator();
        while (iterator.hasNext()) {
            rolePermissionEntry = element$iv = iterator.next();
            boolean bl = false;
            roleId = (String)rolePermissionEntry.getKey();
            permissions = (List)rolePermissionEntry.getValue();
            $this$filter$iv = permissions;
            $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                element$iv$iv = iterator2.next();
                Permission permission = (Permission)element$iv$iv;
                boolean bl2 = false;
                if (!(permission.getEffect() == Effect.DENY)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$forEach = false;
            $this$filterTo$iv$iv = $this$forEach$iv.iterator();
            while ($this$filterTo$iv$iv.hasNext()) {
                Object element$iv2 = $this$filterTo$iv$iv.next();
                Permission permission = (Permission)element$iv2;
                boolean bl3 = false;
                verifyResult = permission.verify(request, context);
                if (verifyResult != VerifyResult.EXPLICIT_DENY) continue;
                if (log.isDebugEnabled()) {
                    log.debug("Verify [" + request + "] [" + context + "] matched Role[" + roleId + "] Permission[" + permission.getId() + "][" + permission.getName() + "] - [Explicit Deny].");
                }
                return new RoleVerifyContext(roleId, permission, verifyResult);
            }
        }
        $this$forEach$iv2 = appRolePermission.getRolePermissionIndexer();
        $i$f$forEach2 = false;
        iterator = $this$forEach$iv2.entrySet().iterator();
        while (iterator.hasNext()) {
            rolePermissionEntry = element$iv = iterator.next();
            boolean bl = false;
            roleId = (String)rolePermissionEntry.getKey();
            permissions = (List)rolePermissionEntry.getValue();
            $this$filter$iv = permissions;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator bl3 = $this$filterTo$iv$iv.iterator();
            while (bl3.hasNext()) {
                element$iv$iv = bl3.next();
                Statement statement = (Statement)element$iv$iv;
                boolean bl4 = false;
                if (!(statement.getEffect() == Effect.ALLOW)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                Permission permission = (Permission)element$iv2;
                boolean bl5 = false;
                verifyResult = permission.verify(request, context);
                if (verifyResult != VerifyResult.ALLOW) continue;
                if (log.isDebugEnabled()) {
                    log.debug("Verify [" + request + "] [" + context + "] matched Role[" + roleId + "] Permission[" + permission.getId() + "][" + permission.getName() + "] - [Allow].");
                }
                return new RoleVerifyContext(roleId, permission, verifyResult);
            }
        }
        return null;
    }

    private final VerifyResult verifyRoot(SecurityContext context) {
        VerifyResult verifyResult;
        if (CoSecPrincipal.Companion.isRoot(context.getPrincipal())) {
            if (log.isDebugEnabled()) {
                log.debug("Verify [" + context + "] matched Root - [Allow].");
            }
            verifyResult = VerifyResult.ALLOW;
        } else {
            verifyResult = VerifyResult.IMPLICIT_DENY;
        }
        return verifyResult;
    }

    private final Mono<VerifyContext> verifyGlobalPolicies(Request request, SecurityContext context) {
        Mono mono = this.policyRepository.getGlobalPolicy().mapNotNull(arg_0 -> SimpleAuthorization.verifyGlobalPolicies$lambda$13((Function1)new Function1<List<? extends Policy>, VerifyContext>(this, request, context){
            final /* synthetic */ SimpleAuthorization this$0;
            final /* synthetic */ Request $request;
            final /* synthetic */ SecurityContext $context;
            {
                this.this$0 = $receiver;
                this.$request = $request;
                this.$context = $context;
                super(1);
            }

            public final VerifyContext invoke(@NotNull List<? extends Policy> policies) {
                Intrinsics.checkNotNullParameter(policies, (String)"policies");
                return SimpleAuthorization.access$verifyPolicies(this.this$0, policies, this.$request, this.$context);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"mapNotNull(...)");
        return mono;
    }

    private final Mono<VerifyContext> verifyPrincipalPolicies(Request request, SecurityContext context) {
        if (context.getPrincipal().getPolicies().isEmpty()) {
            Mono mono = Mono.empty();
            Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"empty(...)");
            return mono;
        }
        Mono mono = this.policyRepository.getPolicies(context.getPrincipal().getPolicies()).mapNotNull(arg_0 -> SimpleAuthorization.verifyPrincipalPolicies$lambda$14((Function1)new Function1<List<? extends Policy>, VerifyContext>(this, request, context){
            final /* synthetic */ SimpleAuthorization this$0;
            final /* synthetic */ Request $request;
            final /* synthetic */ SecurityContext $context;
            {
                this.this$0 = $receiver;
                this.$request = $request;
                this.$context = $context;
                super(1);
            }

            public final VerifyContext invoke(@NotNull List<? extends Policy> policies) {
                Intrinsics.checkNotNullParameter(policies, (String)"policies");
                return SimpleAuthorization.access$verifyPolicies(this.this$0, policies, this.$request, this.$context);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"mapNotNull(...)");
        return mono;
    }

    private final Mono<VerifyContext> verifyAppRolePermission(Request request, SecurityContext context) {
        if (context.getPrincipal().getRoles().isEmpty()) {
            Mono mono = Mono.empty();
            Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"empty(...)");
            return mono;
        }
        Mono mono = this.appRolePermissionRepository.getAppRolePermission(request.getAppId(), context.getPrincipal().getRoles()).mapNotNull(arg_0 -> SimpleAuthorization.verifyAppRolePermission$lambda$15((Function1)new Function1<AppRolePermission, VerifyContext>(this, request, context){
            final /* synthetic */ SimpleAuthorization this$0;
            final /* synthetic */ Request $request;
            final /* synthetic */ SecurityContext $context;
            {
                this.this$0 = $receiver;
                this.$request = $request;
                this.$context = $context;
                super(1);
            }

            public final VerifyContext invoke(AppRolePermission it) {
                Intrinsics.checkNotNull((Object)it);
                return SimpleAuthorization.access$verifyAppRolePermission(this.this$0, it, this.$request, this.$context);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"mapNotNull(...)");
        return mono;
    }

    @NotNull
    public Mono<AuthorizeResult> authorize(@NotNull Request request, @NotNull SecurityContext context) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        VerifyResult verifyResult = this.verifyRoot(context);
        if (verifyResult == VerifyResult.ALLOW) {
            return MonoExtensionsKt.toMono((Object)AuthorizeResult.Companion.getALLOW());
        }
        Mono mono = MonoExtensionsKt.switchIfEmpty((Mono)MonoExtensionsKt.switchIfEmpty(this.verifyGlobalPolicies(request, context), (Function0)((Function0)new Function0<Mono<VerifyContext>>(this, request, context){
            final /* synthetic */ SimpleAuthorization this$0;
            final /* synthetic */ Request $request;
            final /* synthetic */ SecurityContext $context;
            {
                this.this$0 = $receiver;
                this.$request = $request;
                this.$context = $context;
                super(0);
            }

            @NotNull
            public final Mono<VerifyContext> invoke() {
                return SimpleAuthorization.access$verifyPrincipalPolicies(this.this$0, this.$request, this.$context);
            }
        })), (Function0)((Function0)new Function0<Mono<VerifyContext>>(this, request, context){
            final /* synthetic */ SimpleAuthorization this$0;
            final /* synthetic */ Request $request;
            final /* synthetic */ SecurityContext $context;
            {
                this.this$0 = $receiver;
                this.$request = $request;
                this.$context = $context;
                super(0);
            }

            @NotNull
            public final Mono<VerifyContext> invoke() {
                return SimpleAuthorization.access$verifyAppRolePermission(this.this$0, this.$request, this.$context);
            }
        })).map(arg_0 -> SimpleAuthorization.authorize$lambda$16((Function1)new Function1<VerifyContext, AuthorizeResult>(context){
            final /* synthetic */ SecurityContext $context;
            {
                this.$context = $context;
                super(1);
            }

            public final AuthorizeResult invoke(VerifyContext it) {
                Intrinsics.checkNotNull((Object)it);
                VerifyContext.Companion.setVerifyContext(this.$context, it);
                return it.getResult().asAuthorizeResult();
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"map(...)");
        return MonoExtensionsKt.switchIfEmpty((Mono)mono, (Function0)((Function0)new Function0<Mono<AuthorizeResult>>(request, context){
            final /* synthetic */ Request $request;
            final /* synthetic */ SecurityContext $context;
            {
                this.$request = $request;
                this.$context = $context;
                super(0);
            }

            @NotNull
            public final Mono<AuthorizeResult> invoke() {
                if (SimpleAuthorization.access$getLog$cp().isDebugEnabled()) {
                    SimpleAuthorization.access$getLog$cp().debug("Verify [" + this.$request + "] [" + this.$context + "] No policies matched - [Implicit Deny].");
                }
                return MonoExtensionsKt.toMono((Object)AuthorizeResult.Companion.getIMPLICIT_DENY());
            }
        }));
    }

    private static final VerifyContext verifyGlobalPolicies$lambda$13(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (VerifyContext)$tmp0.invoke(p0);
    }

    private static final VerifyContext verifyPrincipalPolicies$lambda$14(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (VerifyContext)$tmp0.invoke(p0);
    }

    private static final VerifyContext verifyAppRolePermission$lambda$15(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (VerifyContext)$tmp0.invoke(p0);
    }

    private static final AuthorizeResult authorize$lambda$16(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (AuthorizeResult)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ VerifyContext access$verifyPolicies(SimpleAuthorization $this, List policies, Request request, SecurityContext securityContext) {
        return $this.verifyPolicies(policies, request, securityContext);
    }

    public static final /* synthetic */ VerifyContext access$verifyAppRolePermission(SimpleAuthorization $this, AppRolePermission appRolePermission, Request request, SecurityContext context) {
        return $this.verifyAppRolePermission(appRolePermission, request, context);
    }

    public static final /* synthetic */ Mono access$verifyPrincipalPolicies(SimpleAuthorization $this, Request request, SecurityContext context) {
        return $this.verifyPrincipalPolicies(request, context);
    }

    public static final /* synthetic */ Mono access$verifyAppRolePermission(SimpleAuthorization $this, Request request, SecurityContext context) {
        return $this.verifyAppRolePermission(request, context);
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lme/ahoo/cosec/authorization/SimpleAuthorization$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "cosec-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

