/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosec.authorization;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.ahoo.cosec.api.policy.Policy;
import me.ahoo.cosec.api.policy.PolicyType;
import me.ahoo.cosec.authorization.LocalPolicyRepository;
import me.ahoo.cosec.authorization.PolicyRepository;
import me.ahoo.cosec.serialization.CoSecJsonSerializer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ResourceUtils;
import reactor.core.publisher.Mono;
import reactor.kotlin.core.publisher.MonoExtensionsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0014\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007H\u0016J\"\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00072\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0016J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002R\u001a\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lme/ahoo/cosec/authorization/LocalPolicyRepository;", "Lme/ahoo/cosec/authorization/PolicyRepository;", "policyPaths", "", "", "(Ljava/util/Set;)V", "globalPolicies", "Lreactor/core/publisher/Mono;", "", "Lme/ahoo/cosec/api/policy/Policy;", "localPolicies", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getGlobalPolicy", "getPolicies", "policyIds", "loadPolicies", "Companion", "cosec-core"})
@SourceDebugExtension(value={"SMAP\nLocalPolicyRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalPolicyRepository.kt\nme/ahoo/cosec/authorization/LocalPolicyRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,79:1\n766#2:80\n857#2,2:81\n1360#2:83\n1446#2,5:84\n1603#2,9:89\n1855#2:98\n1856#2:100\n1612#2:101\n1655#2,8:102\n766#2:110\n857#2,2:111\n1#3:99\n*S KotlinDebug\n*F\n+ 1 LocalPolicyRepository.kt\nme/ahoo/cosec/authorization/LocalPolicyRepository\n*L\n65#1:80\n65#1:81,2\n34#1:83\n34#1:84,5\n46#1:89,9\n46#1:98\n46#1:100\n46#1:101\n60#1:102,8\n74#1:110\n74#1:111,2\n46#1:99\n*E\n"})
public final class LocalPolicyRepository
implements PolicyRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<String> policyPaths;
    private final Logger log;
    @NotNull
    private final List<Policy> localPolicies;
    @NotNull
    private final Mono<List<Policy>> globalPolicies;
    @NotNull
    private static final String POLICY_EXTENSION = "json";

    /*
     * WARNING - void declaration
     */
    public LocalPolicyRepository(@NotNull Set<String> policyPaths) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter(policyPaths, (String)"policyPaths");
        this.policyPaths = policyPaths;
        this.log = LoggerFactory.getLogger(LocalPolicyRepository.class);
        this.localPolicies = this.loadPolicies();
        Iterable iterable = this.localPolicies;
        LocalPolicyRepository localPolicyRepository = this;
        boolean $i$f$filter = false;
        void var4_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Policy it = (Policy)element$iv$iv;
            boolean bl = false;
            if (!(it.getType() == PolicyType.GLOBAL)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        localPolicyRepository.globalPolicies = MonoExtensionsKt.toMono((Object)((List)destination$iv$iv));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final List<Policy> loadPolicies() {
        void $this$mapNotNullTo$iv$iv;
        Object list$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.policyPaths;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List<File> list;
            File policyFile;
            String path = (String)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)ResourceUtils.getFile((String)path), (String)"getFile(...)");
            if (!policyFile.isDirectory()) {
                list = CollectionsKt.listOf((Object)policyFile);
            } else {
                List<File> list2 = Files.walk(policyFile.toPath(), new FileVisitOption[0]).filter(arg_0 -> LocalPolicyRepository.loadPolicies$lambda$2$lambda$0(loadPolicies.policyFiles.1.1.INSTANCE, arg_0)).map(arg_0 -> LocalPolicyRepository.loadPolicies$lambda$2$lambda$1(loadPolicies.policyFiles.1.2.INSTANCE, arg_0)).toList();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"toList(...)");
                list = list2;
            }
            list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List policyFiles2 = (List)destination$iv$iv;
        Iterable $this$mapNotNull$iv = policyFiles2;
        boolean $i$f$mapNotNull = false;
        $this$flatMapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        list$iv$iv = $this$forEach$iv$iv$iv.iterator();
        while (list$iv$iv.hasNext()) {
            Policy policy;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = list$iv$iv.next();
            boolean bl = false;
            File file = (File)element$iv$iv;
            boolean bl2 = false;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Load Policy [{}].", (Object)file);
            }
            try {
                Closeable closeable = file.toURI().toURL().openStream();
                Throwable throwable = null;
                try {
                    InputStream it = (InputStream)closeable;
                    boolean bl3 = false;
                    Policy policy2 = (Policy)CoSecJsonSerializer.INSTANCE.readValue(it, Policy.class);
                    policy = policy2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (Throwable e) {
                if (this.log.isErrorEnabled()) {
                    this.log.error(e.getMessage(), e);
                }
                policy = null;
            }
            if (policy == null) continue;
            Policy it$iv$iv = policy;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$distinctBy$iv = (List)destination$iv$iv;
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            Policy it = (Policy)e$iv;
            boolean bl = false;
            String key$iv = it.getId();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        return list$iv;
    }

    @Override
    @NotNull
    public Mono<List<Policy>> getGlobalPolicy() {
        return this.globalPolicies;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Mono<List<Policy>> getPolicies(@NotNull Set<String> policyIds) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(policyIds, (String)"policyIds");
        Iterable $this$filter$iv = this.localPolicies;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Policy it = (Policy)element$iv$iv;
            boolean bl = false;
            if (!policyIds.contains(it.getId())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return MonoExtensionsKt.toMono((Object)((List)destination$iv$iv));
    }

    private static final boolean loadPolicies$lambda$2$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final File loadPolicies$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (File)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lme/ahoo/cosec/authorization/LocalPolicyRepository$Companion;", "", "()V", "POLICY_EXTENSION", "", "cosec-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

