/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosec.configuration;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.Closeable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.ahoo.cosec.Delegated;
import me.ahoo.cosec.api.configuration.Configuration;
import me.ahoo.cosec.configuration.JsonConfiguration;
import me.ahoo.cosec.serialization.CoSecJsonSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 '2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0001'B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0013\u001a\u00020\u000bH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00010\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0014\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00010\u001dH\u0016J!\u0010\u001f\u001a\u0002H \"\u0004\b\u0000\u0010 2\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H 0\"H\u0016\u00a2\u0006\u0002\u0010#J\b\u0010$\u001a\u00020\u001eH\u0016J\u0012\u0010%\u001a\u0004\u0018\u00010\u00012\u0006\u0010&\u001a\u00020\u001eH\u0016R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\fR\u0014\u0010\r\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\fR\u0014\u0010\u000e\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u000f\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\fR\u0014\u0010\u0010\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\fR\u0014\u0010\u0011\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\fR\u0014\u0010\u0012\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lme/ahoo/cosec/configuration/JsonConfiguration;", "Lme/ahoo/cosec/api/configuration/Configuration;", "Lme/ahoo/cosec/Delegated;", "Lcom/fasterxml/jackson/databind/JsonNode;", "delegate", "objectCodec", "Lcom/fasterxml/jackson/core/ObjectCodec;", "(Lcom/fasterxml/jackson/databind/JsonNode;Lcom/fasterxml/jackson/core/ObjectCodec;)V", "getDelegate", "()Lcom/fasterxml/jackson/databind/JsonNode;", "isArray", "", "()Z", "isBoolean", "isDouble", "isInt", "isLong", "isObject", "isString", "asBoolean", "asDouble", "", "asInt", "", "asList", "", "asLong", "", "asMap", "", "", "asObject", "T", "objectClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)Ljava/lang/Object;", "asString", "get", "key", "Companion", "cosec-core"})
@SourceDebugExtension(value={"SMAP\nJsonConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonConfiguration.kt\nme/ahoo/cosec/configuration/JsonConfiguration\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,114:1\n1#2:115\n*E\n"})
public final class JsonConfiguration
implements Configuration,
Delegated<JsonNode> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JsonNode delegate;
    @NotNull
    private final ObjectCodec objectCodec;
    @NotNull
    private static final Lazy<JsonConfiguration> NULL$delegate = LazyKt.lazy((Function0)Companion.NULL.2.INSTANCE);

    public JsonConfiguration(@NotNull JsonNode delegate, @NotNull ObjectCodec objectCodec) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)objectCodec, (String)"objectCodec");
        this.delegate = delegate;
        this.objectCodec = objectCodec;
    }

    @Override
    @NotNull
    public JsonNode getDelegate() {
        return this.delegate;
    }

    @Nullable
    public Configuration get(@NotNull String key) {
        JsonConfiguration jsonConfiguration;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        JsonNode jsonNode = this.getDelegate().get(key);
        if (jsonNode != null) {
            JsonNode it = jsonNode;
            boolean bl = false;
            jsonConfiguration = new JsonConfiguration(it, this.objectCodec);
        } else {
            jsonConfiguration = null;
        }
        return jsonConfiguration;
    }

    @NotNull
    public List<Configuration> asList() {
        List list;
        List $this$asList_u24lambda_u241 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        Iterator elements = this.getDelegate().elements();
        while (elements.hasNext()) {
            Object e = elements.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            $this$asList_u24lambda_u241.add(new JsonConfiguration((JsonNode)e, this.objectCodec));
        }
        return CollectionsKt.build((List)list);
    }

    @NotNull
    public Map<String, Configuration> asMap() {
        Map map;
        Map $this$asMap_u24lambda_u242 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        Iterator fields = this.getDelegate().fields();
        while (fields.hasNext()) {
            Map.Entry field = (Map.Entry)fields.next();
            Object k = field.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
            Object v = field.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
            $this$asMap_u24lambda_u242.put(k, new JsonConfiguration((JsonNode)v, this.objectCodec));
        }
        return MapsKt.build((Map)map);
    }

    @NotNull
    public String asString() {
        String string = this.getDelegate().asText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asText(...)");
        return string;
    }

    public boolean asBoolean() {
        return this.getDelegate().asBoolean();
    }

    public int asInt() {
        return this.getDelegate().asInt();
    }

    public long asLong() {
        return this.getDelegate().asLong();
    }

    public double asDouble() {
        return this.getDelegate().asDouble();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T asObject(@NotNull Class<T> objectClass) {
        Object object;
        Intrinsics.checkNotNullParameter(objectClass, (String)"objectClass");
        Closeable closeable = (Closeable)this.getDelegate().traverse(this.objectCodec);
        Throwable throwable = null;
        try {
            JsonParser it = (JsonParser)closeable;
            boolean bl = false;
            object = it.readValueAs(objectClass);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return (T)object;
    }

    public boolean isString() {
        return this.getDelegate().isTextual();
    }

    public boolean isBoolean() {
        return this.getDelegate().isBoolean();
    }

    public boolean isInt() {
        return this.getDelegate().isInt();
    }

    public boolean isLong() {
        return this.getDelegate().isLong();
    }

    public boolean isDouble() {
        return this.getDelegate().isDouble();
    }

    public boolean isArray() {
        return this.getDelegate().isArray();
    }

    public boolean isObject() {
        return this.getDelegate().isObject();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\u0010$\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\u0004J\n\u0010\n\u001a\u00020\u0004*\u00020\u000bJ\u0014\u0010\n\u001a\u00020\u0004*\f\u0012\u0004\u0012\u00020\u000b\u0012\u0002\b\u00030\fR\u001b\u0010\u0003\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lme/ahoo/cosec/configuration/JsonConfiguration$Companion;", "", "()V", "NULL", "Lme/ahoo/cosec/configuration/JsonConfiguration;", "getNULL", "()Lme/ahoo/cosec/configuration/JsonConfiguration;", "NULL$delegate", "Lkotlin/Lazy;", "newPojoConfiguration", "asConfiguration", "", "", "cosec-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JsonConfiguration getNULL() {
            Lazy lazy = NULL$delegate;
            return (JsonConfiguration)lazy.getValue();
        }

        @NotNull
        public final JsonConfiguration newPojoConfiguration() {
            return new JsonConfiguration((JsonNode)new ObjectNode(CoSecJsonSerializer.INSTANCE.getNodeFactory()), (ObjectCodec)CoSecJsonSerializer.INSTANCE);
        }

        @NotNull
        public final JsonConfiguration asConfiguration(@NotNull Map<String, ?> $this$asConfiguration) {
            Intrinsics.checkNotNullParameter($this$asConfiguration, (String)"<this>");
            String jsonString = CoSecJsonSerializer.INSTANCE.writeValueAsString($this$asConfiguration);
            JsonNode jsonNode = CoSecJsonSerializer.INSTANCE.readTree(jsonString);
            Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"readTree(...)");
            return new JsonConfiguration(jsonNode, (ObjectCodec)CoSecJsonSerializer.INSTANCE);
        }

        @NotNull
        public final JsonConfiguration asConfiguration(@NotNull String $this$asConfiguration) {
            Intrinsics.checkNotNullParameter((Object)$this$asConfiguration, (String)"<this>");
            return new JsonConfiguration((JsonNode)new TextNode($this$asConfiguration), (ObjectCodec)CoSecJsonSerializer.INSTANCE);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

