/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosec.policy.condition.limiter;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.RateLimiter;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.cosec.api.configuration.Configuration;
import me.ahoo.cosec.policy.condition.limiter.TooManyRequestsException;
import me.ahoo.cosec.policy.condition.part.PartConditionMatcher;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lme/ahoo/cosec/policy/condition/limiter/GroupedRateLimiterConditionMatcher;", "Lme/ahoo/cosec/policy/condition/part/PartConditionMatcher;", "configuration", "Lme/ahoo/cosec/api/configuration/Configuration;", "(Lme/ahoo/cosec/api/configuration/Configuration;)V", "expireAfterAccessSecond", "", "permitsPerSecond", "", "rateLimiters", "Lcom/google/common/cache/LoadingCache;", "", "Lcom/google/common/util/concurrent/RateLimiter;", "matchPart", "", "partValue", "RateLimiterLoader", "cosec-core"})
public final class GroupedRateLimiterConditionMatcher
extends PartConditionMatcher {
    private final double permitsPerSecond;
    private final long expireAfterAccessSecond;
    @NotNull
    private LoadingCache<String, RateLimiter> rateLimiters;

    public GroupedRateLimiterConditionMatcher(@NotNull Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        super("rateLimiter", configuration);
        Configuration configuration2 = configuration.get("permitsPerSecond");
        if (configuration2 == null) {
            GroupedRateLimiterConditionMatcher groupedRateLimiterConditionMatcher = this;
            boolean $i$a$-requireNotNull-GroupedRateLimiterConditionMatcher$permitsPerSecond$22 = false;
            GroupedRateLimiterConditionMatcher groupedRateLimiterConditionMatcher2 = groupedRateLimiterConditionMatcher;
            String $i$a$-requireNotNull-GroupedRateLimiterConditionMatcher$permitsPerSecond$22 = "permitsPerSecond is required!";
            throw new IllegalArgumentException($i$a$-requireNotNull-GroupedRateLimiterConditionMatcher$permitsPerSecond$22.toString());
        }
        this.permitsPerSecond = configuration2.asDouble();
        Configuration configuration3 = configuration.get("expireAfterAccessSecond");
        if (configuration3 == null) {
            GroupedRateLimiterConditionMatcher groupedRateLimiterConditionMatcher = this;
            boolean bl = false;
            GroupedRateLimiterConditionMatcher groupedRateLimiterConditionMatcher3 = groupedRateLimiterConditionMatcher;
            String string = "expireAfterAccessSecond is required!";
            throw new IllegalArgumentException(string.toString());
        }
        this.expireAfterAccessSecond = configuration3.asLong();
        LoadingCache loadingCache = CacheBuilder.newBuilder().expireAfterAccess(this.expireAfterAccessSecond, TimeUnit.SECONDS).build((CacheLoader)new RateLimiterLoader());
        Intrinsics.checkNotNullExpressionValue((Object)loadingCache, (String)"newBuilder()\n        .ex\u2026uild(RateLimiterLoader())");
        this.rateLimiters = loadingCache;
    }

    @Override
    public boolean matchPart(@NotNull String partValue) {
        Intrinsics.checkNotNullParameter((Object)partValue, (String)"partValue");
        Object object = this.rateLimiters.get((Object)partValue);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"rateLimiters.get(partValue)");
        RateLimiter rateLimiter = (RateLimiter)object;
        if (rateLimiter.tryAcquire()) {
            return true;
        }
        throw new TooManyRequestsException();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lme/ahoo/cosec/policy/condition/limiter/GroupedRateLimiterConditionMatcher$RateLimiterLoader;", "Lcom/google/common/cache/CacheLoader;", "", "Lcom/google/common/util/concurrent/RateLimiter;", "(Lme/ahoo/cosec/policy/condition/limiter/GroupedRateLimiterConditionMatcher;)V", "load", "key", "cosec-core"})
    public final class RateLimiterLoader
    extends CacheLoader<String, RateLimiter> {
        @NotNull
        public RateLimiter load(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            RateLimiter rateLimiter = RateLimiter.create((double)GroupedRateLimiterConditionMatcher.this.permitsPerSecond);
            Intrinsics.checkNotNullExpressionValue((Object)rateLimiter, (String)"create(permitsPerSecond)");
            return rateLimiter;
        }
    }
}

